/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DBApp {
    private AppId _id;
    private String _name;
    private boolean _coreApp;
    private int _defaultOrder;

    @Deprecated
    public DBApp() {
    }

    public DBApp(AppId id, String name, boolean coreApp, int defaultOrder) {
        this._id = id;
        this._name = name;
        this._coreApp = coreApp;
        this._defaultOrder = defaultOrder;
    }

    @Nonnull
    public AppId getId() {
        return this._id;
    }

    public void setId(AppId id) {
        this._id = id;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isCoreApp() {
        return this._coreApp;
    }

    public void setCoreApp(boolean coreApp) {
        this._coreApp = coreApp;
    }

    public int getDefaultOrder() {
        return this._defaultOrder;
    }

    public void setDefaultOrder(int defaultOrder) {
        this._defaultOrder = defaultOrder;
    }

    @Nonnull
    private Object[] hashObject() {
        return new Object[]{this._id, this._name, this._coreApp, this._defaultOrder};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DBApp && Arrays.equals(this.hashObject(), ((DBApp)obj).hashObject());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObject());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("name", (Object)this._name).add("coreApp", this._coreApp).add("defaultOrder", this._defaultOrder).toString();
    }

    @Nonnull
    public static DBApp fromAppConfig(AppConfig appConfig, int defaultOrder) {
        boolean isCoreApp = CoreApp.byAppId(appConfig.getAppId()) != null;
        return new DBApp(appConfig.getAppId(), appConfig.getName(), isCoreApp, defaultOrder);
    }
}

