/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class AppConfigsBuilder {
    private static final Predicate<AppConfig> IS_CORE_APP = appConfig -> CoreApp.byAppId(appConfig.getAppId()) != null;
    private final LinkedList<AppConfig> _currentAppConfigs;

    private AppConfigsBuilder(ImmutableList<AppConfig> initialAppConfigs) {
        this._currentAppConfigs = new LinkedList<AppConfig>((Collection<AppConfig>)initialAppConfigs);
    }

    @Nonnull
    public static AppConfigsBuilder from(ImmutableList<AppConfig> appConfigs) {
        return new AppConfigsBuilder(appConfigs);
    }

    @Nonnull
    public AppConfigsBuilder addAfterLastCoreApp(AppConfig appToAdd) {
        if (!this.appIdExists(appToAdd.getAppId())) {
            this.findLastCoreApp().ifPresent(coreApp -> this.addAppAfter(appToAdd, (AppConfig)coreApp));
        }
        return this;
    }

    @Nonnull
    public ImmutableList<AppConfig> toList() {
        return ImmutableList.copyOf(this._currentAppConfigs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentAppConfigs", this._currentAppConfigs).toString();
    }

    private boolean appIdExists(AppId appId) {
        return this._currentAppConfigs.stream().anyMatch(AppConfigsBuilder.isAppId(appId));
    }

    @Nonnull
    private Optional<AppConfig> findLastCoreApp() {
        return this._currentAppConfigs.stream().filter(IS_CORE_APP).reduce((first, second) -> second);
    }

    private void addAppAfter(AppConfig appToAdd, AppConfig appToAddAfter) {
        this._currentAppConfigs.add(this._currentAppConfigs.indexOf(appToAddAfter) + 1, appToAdd);
    }

    @Nonnull
    private static Predicate<AppConfig> isAppId(AppId appId) {
        return appConfig -> appId.equals(appConfig.getAppId());
    }
}

