/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.appswitcher.model.DBAdditionalAppInfo;
import de.justsoftware.onx.appswitcher.model.DBApp;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AppConfig {
    private final AppId _appId;
    private final String _name;
    private final String _url;
    private final String _appColor;
    private final String _icon;
    private final Boolean _iframeApp;
    private final Boolean _openInSameTab;

    @JsonCreator
    public AppConfig(@JsonProperty(value="appId", required=true) AppId appId, @JsonProperty(value="name", required=true) String name, @Nullable @JsonProperty(value="url", required=false) String url, @Nullable @JsonProperty(value="appColor", required=false) String appColor, @Nullable @JsonProperty(value="icon", required=false) String icon, @Nullable @JsonProperty(value="iframeApp", required=false) Boolean iframeApp, @Nullable @JsonProperty(value="openInSameTab", required=false) Boolean openInSameTab) {
        boolean isCoreApp;
        this._appId = appId;
        this._name = name;
        boolean bl = isCoreApp = CoreApp.byAppId(this._appId) != null;
        if (isCoreApp) {
            this._url = null;
            this._appColor = null;
            this._icon = null;
            this._iframeApp = null;
            this._openInSameTab = null;
        } else {
            if (url == null || appColor == null || iframeApp == null) {
                throw new IllegalArgumentException("External Apps have to define url, appColor and iframeApp flag");
            }
            this._url = url;
            this._appColor = appColor;
            this._icon = icon;
            this._iframeApp = iframeApp;
            this._openInSameTab = openInSameTab == null ? Boolean.FALSE : openInSameTab;
        }
    }

    @Nonnull
    public AppId getAppId() {
        return this._appId;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public String getUrl() {
        return this._url;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public String getAppColor() {
        return this._appColor;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public String getIcon() {
        return this._icon;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public Boolean getIframeApp() {
        return this._iframeApp;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @CheckForNull
    public Boolean isOpenInSameTab() {
        return this._openInSameTab;
    }

    @Nonnull
    private Object[] hashObjects() {
        return new Object[]{this._appId, this._name, this._url, this._icon, this._appColor, this._iframeApp, this._openInSameTab};
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof AppConfig && Arrays.equals(this.hashObjects(), ((AppConfig)obj).hashObjects());
    }

    public int hashCode() {
        return Arrays.hashCode(this.hashObjects());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this._appId).add("name", (Object)this._name).add("url", (Object)this._url).add("icon", (Object)this._icon).add("appColor", (Object)this._appColor).add("iframeApp", (Object)this._iframeApp).add("openInSameTab", (Object)this._openInSameTab).toString();
    }

    @CheckForNull
    public static AppConfig fromDBModels(DBApp dbApp, @Nullable DBAdditionalAppInfo dbAdditionalAppInfo) {
        if (!dbApp.isCoreApp() && dbAdditionalAppInfo == null) {
            return null;
        }
        return new AppConfig(dbApp.getId(), dbApp.getName(), dbAdditionalAppInfo != null ? dbAdditionalAppInfo.getUrl() : null, dbAdditionalAppInfo != null ? dbAdditionalAppInfo.getColor() : null, dbAdditionalAppInfo != null ? dbAdditionalAppInfo.getIcon() : null, dbAdditionalAppInfo != null ? Boolean.valueOf(dbAdditionalAppInfo.isIframeApp()) : null, dbAdditionalAppInfo != null ? Boolean.valueOf(dbAdditionalAppInfo.isOpenInSameTab()) : null);
    }
}

