/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.appswitcher.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.integration.persistence.AppConfigDAO;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.model.DBAdditionalAppInfo;
import de.justsoftware.onx.appswitcher.model.DBApp;
import de.justsoftware.onx.appswitcher.model.DBAppVisibility;
import de.justsoftware.onx.appswitcher.model.DBTenantAppVisibility;
import de.justsoftware.onx.appswitcher.model.UserAppConfig;
import de.justsoftware.onx.appswitcher.model.UserCoreAppConfig;
import de.justsoftware.onx.appswitcher.model.UserExternalAppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractSingleLoadingCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class AppConfigServiceImpl
implements AppConfigService {
    private final PermissionRequestConnector _permissionRequestConnector;
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final AppConfigDAO _appConfigDAO;
    private final AppVisibilitiesByTenantIdsCacheAccessor _appVisibilitiesByTenantIdCacheAccessor;
    private final DefaultAppVisibilitiesCacheAccessor _defaultAppVisibilitiesCacheAccessor;
    private final AllAdditionalAppInfoCacheAccessor _allAdditionalAppInfoCacheAccessor;
    private final AllAppsCacheAccessor _allAppsCacheAccessor;
    private final TransactionHelper _transactionHelper;

    @Autowired
    public AppConfigServiceImpl(EhcacheClient cacheClient, AppConfigDAO appConfigDAO, PermissionRequestConnector permissionRequestConnector, AuthorizationContextProvider authorizationContextProvider, TransactionHelper transactionHelper) {
        this._appConfigDAO = appConfigDAO;
        this._permissionRequestConnector = permissionRequestConnector;
        this._authorizationContextProvider = authorizationContextProvider;
        this._appVisibilitiesByTenantIdCacheAccessor = new AppVisibilitiesByTenantIdsCacheAccessor(cacheClient, this._appConfigDAO);
        this._defaultAppVisibilitiesCacheAccessor = new DefaultAppVisibilitiesCacheAccessor(cacheClient, this._appConfigDAO);
        this._allAdditionalAppInfoCacheAccessor = new AllAdditionalAppInfoCacheAccessor(cacheClient, this._appConfigDAO);
        this._allAppsCacheAccessor = new AllAppsCacheAccessor(cacheClient, this._appConfigDAO);
        this._transactionHelper = transactionHelper;
    }

    @Override
    public ImmutableList<AppId> getAvailableAppIds(PersonId personId) {
        return this.getAvailableAppIds(this._authorizationContextProvider.getAuthorizationContextForUser(personId));
    }

    @Override
    public ImmutableList<AppId> getAvailableAppIds(AuthorizationContext authCtx) {
        return (ImmutableList)this.getAvailableAppConfigs(authCtx).stream().map(UserAppConfig::getAppId).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<UserAppConfig> getAvailableAppConfigs(AuthorizationContext authCtx) {
        ImmutableList<DBApp> allApps = this.getAllApps();
        ImmutableMap availableAppVisibilities = (ImmutableMap)this.getAvailableAppVisibilities(authCtx).stream().collect(ImmutableMap.toImmutableMap(DBAppVisibility::getAppId, Function.identity()));
        ImmutableMap<AppId, DBAdditionalAppInfo> allAdditionalAppInfo = this.getAllAdditionalAppInfo();
        return (ImmutableList)allApps.stream().map(this.toJustAppConfiguration((ImmutableMap<AppId, DBAppVisibility>)availableAppVisibilities, allAdditionalAppInfo, authCtx)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private Function<DBApp, UserAppConfig> toJustAppConfiguration(ImmutableMap<AppId, DBAppVisibility> availableAppVisibilities, ImmutableMap<AppId, DBAdditionalAppInfo> allAdditionalAppInfos, AuthorizationContext authCtx) {
        return app -> {
            Optional<TenantId> optionalTenantId = authCtx.getOptionalTenantId();
            if (optionalTenantId.isEmpty() && !CoreApp.ADMIN.getAppId().equals(app.getId())) {
                return null;
            }
            DBAppVisibility appVisibility = (DBAppVisibility)availableAppVisibilities.get((Object)app.getId());
            if (appVisibility == null) {
                return null;
            }
            if (app.isCoreApp()) {
                CoreApp coreApp = CoreApp.byAppId(app.getId());
                if (coreApp == null) {
                    return null;
                }
                Action requiredAction = coreApp.getActionNeeded();
                if (requiredAction == null || authCtx.may(requiredAction)) {
                    return new UserCoreAppConfig(coreApp, app.getName(), appVisibility.getVisibility());
                }
                return null;
            }
            DBAdditionalAppInfo additionalAppInfo = (DBAdditionalAppInfo)allAdditionalAppInfos.get((Object)appVisibility.getAppId());
            return additionalAppInfo != null ? new UserExternalAppConfig(app.getId(), app.getName(), additionalAppInfo.getUrl(), additionalAppInfo.getColor(), additionalAppInfo.getIcon(), additionalAppInfo.isIframeApp(), additionalAppInfo.isOpenInSameTab(), appVisibility.getVisibility()) : null;
        };
    }

    @Nonnull
    private ImmutableList<DBAppVisibility> getAvailableAppVisibilities(AuthorizationContext authCtx) {
        Optional<TenantId> tenantId = authCtx.getOptionalTenantId();
        ImmutableList<DBAppVisibility> defaultAppsVisibilities = this.getDefaultAppVisibilities();
        ImmutableList tenantAppsVisibility = tenantId.map(this::getTenantAppVisibilities).orElse(ImmutableList.of());
        Role tenantManagerRole = tenantId.map(t -> Role.manage((String)t.asString())).orElse(Role.SUPERADMIN);
        ImmutableMap visibilitiesToRole = (ImmutableMap)Stream.concat(defaultAppsVisibilities.stream(), tenantAppsVisibility.stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), visibility -> this.convertVisibilityToRole((DBAppVisibility)visibility, tenantManagerRole)));
        ImmutableSet appRoles = ImmutableSet.copyOf((Collection)visibilitiesToRole.values());
        ImmutableSet<Role> appRolesFilteredByUserRoles = this.filterByUserRoles((ImmutableSet<Role>)appRoles, authCtx.getUserId());
        Map<AppId, List<DBAppVisibility>> availableAppVisibilities = visibilitiesToRole.entrySet().stream().filter(entry -> appRolesFilteredByUserRoles.contains(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.groupingBy(DBAppVisibility::getAppId));
        return (ImmutableList)availableAppVisibilities.values().stream().map(this::getStrongestVisibility).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private Role convertVisibilityToRole(DBAppVisibility visibility, Role tenantManagerRole) {
        return visibility.getVisibleForRole().equals("TENANT_MANAGER") ? tenantManagerRole : Role.create((String)visibility.getVisibleForRole());
    }

    @Nonnull
    private ImmutableSet<Role> filterByUserRoles(ImmutableSet<Role> roles, PersonId personId) {
        Role userRole = Role.profileRole((long)personId.getId());
        return (ImmutableSet)this._permissionRequestConnector.hasRoles(roles, (Iterable)ImmutableSet.of((Object)userRole)).entrySet().stream().filter(e -> e.getValue() == AuthorizationResult.OK).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @CheckForNull
    private DBAppVisibility getStrongestVisibility(List<DBAppVisibility> appVisibilities) {
        if (appVisibilities.isEmpty()) {
            return null;
        }
        return appVisibilities.stream().filter(Objects::nonNull).reduce(appVisibilities.get(0), (a, b) -> a.getVisibility().ordinal() < b.getVisibility().ordinal() ? b : a);
    }

    @Nonnull
    private ImmutableList<DBTenantAppVisibility> getTenantAppVisibilities(TenantId tenantId) {
        return (ImmutableList)MoreObjects.firstNonNull((Object)((ImmutableList)this._appVisibilitiesByTenantIdCacheAccessor.getSingle(tenantId)), (Object)ImmutableList.of());
    }

    @Nonnull
    private ImmutableList<DBTenantAppVisibility> getTenantAppVisibilitiesByRoles(TenantId tenantId, Role role) {
        return (ImmutableList)this.getTenantAppVisibilities(tenantId).stream().filter(visibility -> role.asString().equals(visibility.getVisibleForRole())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableMap<AppId, DBAdditionalAppInfo> getAllAdditionalAppInfo() {
        return (ImmutableMap)MoreObjects.firstNonNull((Object)((ImmutableMap)this._allAdditionalAppInfoCacheAccessor.getSingle(Optional.empty())), (Object)ImmutableMap.of());
    }

    @Nonnull
    private ImmutableList<DBAppVisibility> getDefaultAppVisibilities() {
        return (ImmutableList)MoreObjects.firstNonNull((Object)((ImmutableList)this._defaultAppVisibilitiesCacheAccessor.getSingle(Optional.empty())), (Object)ImmutableList.of());
    }

    @Nonnull
    private ImmutableList<DBAppVisibility> getDefaultAppVisibilitiesByRoles(Role role) {
        return (ImmutableList)this.getDefaultAppVisibilities().stream().filter(visibility -> role.asString().equals(visibility.getVisibleForRole())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private ImmutableList<DBApp> getAllApps() {
        return (ImmutableList)MoreObjects.firstNonNull((Object)((ImmutableList)this._allAppsCacheAccessor.getSingle(Optional.empty())), (Object)ImmutableList.of());
    }

    @Override
    public void setAllAppConfigs(ImmutableList<AppConfig> newAppConfigs) {
        ImmutableList<DBApp> currentApps = this.getAllApps();
        ArrayList<DBApp> newApps = new ArrayList<DBApp>(newAppConfigs.size());
        ImmutableCollection currentAdditionalAppInfo = this.getAllAdditionalAppInfo().values();
        ArrayList<DBAdditionalAppInfo> newAdditionalAppInfo = new ArrayList<DBAdditionalAppInfo>(newAppConfigs.size());
        for (int defaultOrder = 0; defaultOrder < newAppConfigs.size(); ++defaultOrder) {
            AppConfig appConfig = (AppConfig)newAppConfigs.get(defaultOrder);
            newApps.add(DBApp.fromAppConfig(appConfig, defaultOrder));
            DBAdditionalAppInfo dbAdditionalAppInfo = DBAdditionalAppInfo.fromAppConfig(appConfig);
            if (dbAdditionalAppInfo == null) continue;
            newAdditionalAppInfo.add(dbAdditionalAppInfo);
        }
        DBChanges<DBApp> appChanges = this.getChanges((Collection)currentApps, (Collection)newApps, (Function)DBApp::getId);
        DBChanges<DBAdditionalAppInfo> additionalAppInfoChanges = this.getChanges((Collection)currentAdditionalAppInfo, (Collection)newAdditionalAppInfo, (Function)DBAdditionalAppInfo::getAppId);
        this.executeAllDBAppAndDBAdditionalAppInfoChanges(appChanges, additionalAppInfoChanges);
    }

    private void executeAllDBAppAndDBAdditionalAppInfoChanges(DBChanges<DBApp> appChanges, DBChanges<DBAdditionalAppInfo> additionalAppInfoChanges) {
        ImmutableSet appIdsToDelete = (ImmutableSet)appChanges._dataToDelete.stream().map(DBApp::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableSet additionalInfoAppIdsToDelete = (ImmutableSet)additionalAppInfoChanges._dataToDelete.stream().map(DBAdditionalAppInfo::getAppId).collect(ImmutableSet.toImmutableSet());
        this._transactionHelper.doInTransactionWithoutResult(transactionStatus -> {
            this._appConfigDAO.deleteAppsByIds((Set<AppId>)appIdsToDelete);
            appChanges._dataToInsert.forEach(this._appConfigDAO::insertApp);
            appChanges._dataToUpdate.forEach(this._appConfigDAO::updateApp);
            this._appConfigDAO.deleteAdditionalAppInfoByAppIds((Set<AppId>)additionalInfoAppIdsToDelete);
            additionalAppInfoChanges._dataToInsert.forEach(this._appConfigDAO::insertAdditionalAppInfo);
            additionalAppInfoChanges._dataToUpdate.forEach(this._appConfigDAO::updateAdditionalAppInfo);
        });
        this._allAppsCacheAccessor.invalidateAll();
        this._allAdditionalAppInfoCacheAccessor.invalidateAll();
        this._defaultAppVisibilitiesCacheAccessor.invalidateAll();
        this._appVisibilitiesByTenantIdCacheAccessor.invalidateAll();
    }

    private void checkAppIdsExist(Set<AppId> appIdsToCheck) throws IllegalArgumentException {
        ImmutableSet existingAppIds = (ImmutableSet)this.getAllApps().stream().map(DBApp::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableList invalidAppIds = (ImmutableList)appIdsToCheck.stream().filter(Predicates.not(arg_0 -> ((ImmutableSet)existingAppIds).contains(arg_0))).collect(ImmutableList.toImmutableList());
        if (!invalidAppIds.isEmpty()) {
            throw new IllegalArgumentException("Apps with ids [" + Joiner.on((String)", ").join((Iterable)invalidAppIds) + "] does not exists");
        }
    }

    @Override
    public void setInitialAppVisibilityConfigsForRoleAndTenant(Role role, TenantId tenantId, ImmutableMap<AppId, InitialVisibility> appVisibilities) throws IllegalArgumentException {
        this.checkAppIdsExist((Set<AppId>)appVisibilities.keySet());
        if (tenantId == null) {
            this.setDefaultAppVisibilityForRole(role, appVisibilities);
        } else {
            this.setTenantAppVisibilityForRole(role, tenantId, appVisibilities);
        }
    }

    private void setTenantAppVisibilityForRole(Role role, TenantId tenantId, ImmutableMap<AppId, InitialVisibility> appVisibilities) throws IllegalArgumentException {
        ImmutableList<DBTenantAppVisibility> currentAppVisibilities = this.getTenantAppVisibilitiesByRoles(tenantId, role);
        String roleAsString = role.asString();
        ImmutableList newAppVisibilities = (ImmutableList)appVisibilities.entrySet().stream().map(entry -> new DBTenantAppVisibility((AppId)entry.getKey(), tenantId, roleAsString, (InitialVisibility)((Object)((Object)entry.getValue())))).collect(ImmutableList.toImmutableList());
        DBChanges<DBTenantAppVisibility> changes = this.getChanges((Collection)currentAppVisibilities, (Collection)newAppVisibilities, (Function)DBAppVisibility::getAppId);
        this._transactionHelper.doInTransactionWithoutResult(transactionStatus -> {
            this._appConfigDAO.deleteTenantAppVisibilities(changes._dataToDelete);
            changes._dataToInsert.forEach(this._appConfigDAO::insertTenantAppVisibility);
            changes._dataToUpdate.forEach(this._appConfigDAO::updateTenantAppVisibility);
        });
        this._appVisibilitiesByTenantIdCacheAccessor.invalidateKey(tenantId);
    }

    private void setDefaultAppVisibilityForRole(Role role, ImmutableMap<AppId, InitialVisibility> newAppVisibilities) {
        ImmutableList<DBAppVisibility> currentAppVisibilities = this.getDefaultAppVisibilitiesByRoles(role);
        String stringRole = role.asString();
        ImmutableList newDBAppVisibilities = (ImmutableList)newAppVisibilities.entrySet().stream().map(entry -> new DBAppVisibility((AppId)entry.getKey(), stringRole, (InitialVisibility)((Object)((Object)entry.getValue())))).collect(ImmutableList.toImmutableList());
        DBChanges<DBAppVisibility> changes = this.getChanges((Collection)currentAppVisibilities, (Collection)newDBAppVisibilities, (Function)DBAppVisibility::getAppId);
        this._transactionHelper.doInTransactionWithoutResult(transactionStatus -> {
            ImmutableSet toDeletedAppIds = (ImmutableSet)changes._dataToDelete.stream().map(DBAppVisibility::getAppId).collect(ImmutableSet.toImmutableSet());
            this._appConfigDAO.deleteDefaultAppVisibilitiesByAppIds((Set<AppId>)toDeletedAppIds);
            changes._dataToInsert.forEach(this._appConfigDAO::insertDefaultAppVisibility);
            changes._dataToUpdate.forEach(this._appConfigDAO::updateDefaultAppVisibility);
        });
        this._defaultAppVisibilitiesCacheAccessor.invalidateAll();
    }

    @Nonnull
    private <T, ID> DBChanges<T> getChanges(Collection<T> currentData, Collection<T> newData, Function<T, ID> getIdFunction) {
        DBChanges changes = new DBChanges();
        Map idToCurrentData = currentData.stream().collect(Collectors.toMap(getIdFunction, Function.identity()));
        for (T newValue : newData) {
            ID id = getIdFunction.apply(newValue);
            Object currentDBValue = idToCurrentData.get(id);
            if (currentDBValue == null) {
                changes._dataToInsert.add(newValue);
            } else if (!currentDBValue.equals(newValue)) {
                changes._dataToUpdate.add(newValue);
            }
            idToCurrentData.remove(id);
        }
        changes._dataToDelete.addAll(idToCurrentData.values());
        return changes;
    }

    @Override
    public ImmutableList<AppConfig> getAllAppConfigs() {
        ImmutableList<DBApp> allDBApps = this.getAllApps();
        ImmutableMap<AppId, DBAdditionalAppInfo> allAdditionalAppInfo = this.getAllAdditionalAppInfo();
        return (ImmutableList)allDBApps.stream().map(dbApp -> AppConfig.fromDBModels(dbApp, (DBAdditionalAppInfo)allAdditionalAppInfo.get((Object)dbApp.getId()))).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableTable<Role, AppId, InitialVisibility> getInitialAppVisibilityConfigsByTenant(TenantId tenantId) {
        ImmutableList<DBAppVisibility> appVisibilities = tenantId == null ? this.getDefaultAppVisibilities() : this.getTenantAppVisibilities(tenantId);
        return (ImmutableTable)appVisibilities.stream().collect(ImmutableTable.toImmutableTable(appVisibility -> Role.create((String)appVisibility.getVisibleForRole()), appVisibility -> appVisibility.getAppId(), appVisibility -> appVisibility.getVisibility()));
    }

    @Override
    public void setInitialAppVisibilityConfigsByTenant(TenantId tenantId, ImmutableTable<Role, AppId, InitialVisibility> newAppVisibilitiesByRoles) {
        ImmutableTable<Role, AppId, InitialVisibility> currentConfigs = this.getInitialAppVisibilityConfigsByTenant(tenantId);
        Sets.SetView rolesToModify = Sets.union((Set)currentConfigs.rowKeySet(), (Set)newAppVisibilitiesByRoles.rowKeySet());
        this._transactionHelper.doInTransactionWithoutResult(transactionStatus -> {
            for (Role role : rolesToModify) {
                this.setInitialAppVisibilityConfigsForRoleAndTenant(role, tenantId, (ImmutableMap<AppId, InitialVisibility>)newAppVisibilitiesByRoles.row((Object)role));
            }
        });
        if (tenantId == null) {
            this._defaultAppVisibilitiesCacheAccessor.invalidateAll();
        } else {
            this._appVisibilitiesByTenantIdCacheAccessor.invalidateKey(tenantId);
        }
    }

    private static class DBChanges<DBType> {
        private final Set<DBType> _dataToDelete = new HashSet<DBType>();
        private final List<DBType> _dataToInsert = new ArrayList<DBType>();
        private final List<DBType> _dataToUpdate = new ArrayList<DBType>();

        private DBChanges() {
        }
    }

    @ParametersAreNonnullByDefault
    private static class DefaultAppVisibilitiesCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<AppConfigCacheName, Optional<Void>, ImmutableList<DBAppVisibility>> {
        private final AppConfigDAO _dao;

        protected DefaultAppVisibilitiesCacheAccessor(CacheClient<? super AppConfigCacheName> cache, AppConfigDAO dao) {
            super(cache, AppConfigCacheName.DEFAULT_APP_VISIBILITIES);
            this._dao = dao;
        }

        @Override
        protected ImmutableList<DBAppVisibility> getFromDatabaseSingle(Optional<Void> input) {
            return this._dao.getAllDefaultAppVisibilities();
        }

        @Override
        protected String keyToString(Optional<Void> key) {
            return "";
        }
    }

    private static class AllAppsCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<AppConfigCacheName, Optional<Void>, ImmutableList<DBApp>> {
        private final AppConfigDAO _dao;

        protected AllAppsCacheAccessor(CacheClient<? super AppConfigCacheName> cache, AppConfigDAO dao) {
            super(cache, AppConfigCacheName.ALL_APPS);
            this._dao = dao;
        }

        @Override
        protected ImmutableList<DBApp> getFromDatabaseSingle(Optional<Void> input) {
            return this._dao.getAllApps();
        }

        @Override
        protected String keyToString(Optional<Void> key) {
            return "";
        }
    }

    @ParametersAreNonnullByDefault
    private static class AllAdditionalAppInfoCacheAccessor
    extends AbstractSingleLoadingCacheAccessor<AppConfigCacheName, Optional<Void>, ImmutableMap<AppId, DBAdditionalAppInfo>> {
        private final AppConfigDAO _dao;

        protected AllAdditionalAppInfoCacheAccessor(CacheClient<? super AppConfigCacheName> cache, AppConfigDAO dao) {
            super(cache, AppConfigCacheName.ALL_ADDITIONAL_APP_INFO);
            this._dao = dao;
        }

        @Override
        protected ImmutableMap<AppId, DBAdditionalAppInfo> getFromDatabaseSingle(Optional<Void> input) {
            return (ImmutableMap)this._dao.getAllAdditionalAppInfo().stream().collect(ImmutableMap.toImmutableMap(DBAdditionalAppInfo::getAppId, Function.identity()));
        }

        @Override
        protected String keyToString(Optional<Void> key) {
            return "";
        }
    }

    @ParametersAreNonnullByDefault
    private static class AppVisibilitiesByTenantIdsCacheAccessor
    extends AbstractListMultiMapCacheAccessor<AppConfigCacheName, TenantId, DBTenantAppVisibility> {
        private final AppConfigDAO _dao;

        protected AppVisibilitiesByTenantIdsCacheAccessor(CacheClient<? super AppConfigCacheName> cache, AppConfigDAO dao) {
            super(cache, AppConfigCacheName.APP_VISIBILITIES_BY_TENANT_ID);
            this._dao = dao;
        }

        @Override
        protected Iterable<? extends DBTenantAppVisibility> getListFromDatabase(Set<? extends TenantId> tenantIds) {
            return this._dao.getTenantAppVisibilitiesByTenantIds(tenantIds);
        }

        @Override
        protected String keyToString(TenantId key) {
            return key.asString();
        }

        @Override
        protected TenantId objectToKey(DBTenantAppVisibility dbResult) {
            return dbResult.getTenantId();
        }
    }

    public static enum AppConfigCacheName implements EhCacheName
    {
        APP_VISIBILITIES_BY_TENANT_ID("appConfig.appVisibilitiesByTenantId"),
        DEFAULT_APP_VISIBILITIES("appConfig.defaultAppVisibilities"),
        ALL_ADDITIONAL_APP_INFO("appConfig.allAdditionalAppInfo"),
        ALL_APPS("appConfig.allApps");

        private final String _cacheName;

        private AppConfigCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }
}

