/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlbumItem
implements Item<AlbumId> {
    public static final Function<DBAlbum, AlbumItem> FROM_DBALBUM = new Function<DBAlbum, AlbumItem>(){

        public AlbumItem apply(DBAlbum input) {
            return AlbumItem.of(input);
        }
    };
    private final DBAlbum _album;

    public AlbumItem(@Nonnull DBAlbum album) {
        this._album = album;
    }

    @CheckForNull
    protected static AlbumItem of(@Nullable DBAlbum album) {
        return album != null ? new AlbumItem(album) : null;
    }

    @Nonnull
    public DBAlbum getAlbum() {
        return this._album;
    }

    @Override
    public AlbumId getId() {
        return this._album.getId();
    }

    @Override
    public GlobalId getParentId() {
        return this._album.getParentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.ALBUMS;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("album", (Object)this._album).toString();
    }
}

