/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiable;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DBAlbum
implements Serializable,
Identifiable<AlbumId> {
    public static final Function<DBAlbum, PersonId> GET_OWNER = new Function<DBAlbum, PersonId>(){

        public PersonId apply(DBAlbum input) {
            return input != null ? input.getOwnerId() : null;
        }
    };
    public static final Predicate<DBAlbum> IS_MODULE = new Predicate<DBAlbum>(){

        public boolean apply(DBAlbum input) {
            return input != null && input.isModule();
        }
    };
    public static final Function<DBAlbum, GlobalId> GET_PARENT_ID = new Function<DBAlbum, GlobalId>(){

        public GlobalId apply(DBAlbum input) {
            return input != null ? input.getParentId() : null;
        }
    };
    private static final long serialVersionUID = -7590668220105006169L;
    private AlbumId _id;
    private GlobalId _parentId;
    private boolean _module;
    private Date _createDate;
    private Date _editDate;
    private String _title;
    private String _description;
    private String _location;
    private boolean _friendsOnly;
    private PersonId _ownerId;

    @Override
    public AlbumId getId() {
        return this._id;
    }

    public void setId(AlbumId id) {
        this._id = id;
    }

    @Nonnull
    public GlobalId getParentId() {
        return this._parentId;
    }

    public void setParentId(GlobalId parentId) {
        this._parentId = parentId;
    }

    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    public void setCreateDate(Date createDate) {
        this._createDate = Dates.clone(createDate);
    }

    public Date getEditDate() {
        return Dates.clone(this._editDate);
    }

    public void setEditDate(Date editDate) {
        this._editDate = Dates.clone(editDate);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public boolean isFriendsOnly() {
        return this._friendsOnly;
    }

    public void setFriendsOnly(boolean friendsOnly) {
        this._friendsOnly = friendsOnly;
    }

    public boolean isModule() {
        return this._module;
    }

    public void setModule(boolean isModule) {
        this._module = isModule;
    }

    @CheckForNull
    public PersonId getOwnerId() {
        return this._ownerId;
    }

    public void setOwnerId(PersonId ownerId) {
        this._ownerId = ownerId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("parentId", (Object)this._parentId).add("module", this._module).add("createDate", (Object)this._createDate).add("editDate", (Object)this._editDate).add("title", (Object)this._title).add("description", (Object)this._description).add("location", (Object)this._location).add("friendsOnly", this._friendsOnly).add("ownerId", (Object)this._ownerId).toString();
    }
}

