/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.album.business.AlbumImageDeletionHandler;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlbumImageDeletionHandlerImpl
implements AlbumImageDeletionHandler {
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext context) {
        ImmutableSet.Builder imageIdsToDeleteBuilder = ImmutableSet.builder();
        ImmutableSet albumIds = ImmutableSet.copyOf((Iterable)Iterables.filter(parentIds, AlbumId.class));
        this.handleCascadeDeleteByAlbumId((Set<AlbumId>)albumIds, context, (ImmutableSet.Builder<AlbumImageId>)imageIdsToDeleteBuilder);
        ImmutableSet imageIdsToDelete = imageIdsToDeleteBuilder.build();
        if (!imageIdsToDelete.isEmpty()) {
            this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)imageIdsToDelete, context);
            this._albumService.deleteDependentImages((Set<AlbumImageId>)imageIdsToDelete, context);
        }
    }

    private void handleCascadeDeleteByAlbumId(@Nonnull Set<AlbumId> albumIds, @Nonnull DeletionContext context, @Nonnull ImmutableSet.Builder<AlbumImageId> imageIdsToDeleteBuilder) {
        ImmutableListMultimap<AlbumId, DBAlbumImage> imagesToDelete = this._albumService.getImagesByAlbumIds(albumIds);
        Iterable imageIdsToDelete = Iterables.transform((Iterable)imagesToDelete.values(), DBAlbumImage.TO_ID);
        this.addToDeletionContextIfNotDeleted(imageIdsToDelete, context, imageIdsToDeleteBuilder);
    }

    private void addToDeletionContextIfNotDeleted(@Nonnull Iterable<AlbumImageId> imageIdsToDelete, @Nonnull DeletionContext context, @Nonnull ImmutableSet.Builder<AlbumImageId> imageIdsToDeleteBuilder) {
        for (AlbumImageId imageIdToDelete : imageIdsToDelete) {
            if (context.isItemDeleted(imageIdToDelete)) continue;
            context.addDeletedItem(imageIdToDelete);
            context.addServerEvent(new ItemDeletedEvent(imageIdToDelete));
            imageIdsToDeleteBuilder.add((Object)imageIdToDelete);
        }
    }
}

