/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.album.business.AlbumImageCreatedStreamHandler;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.album.shared.model.DBAlbumImage;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumImageCreated;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="albumImageCreatedStreamHandler")
public class AlbumImageCreatedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<AlbumImageCreated>
implements AlbumImageCreatedStreamHandler {
    @Autowired
    private AlbumService _albumService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return AlbumImageCreatedStreamHandlerImpl.attributesToDelete(itemIds, "image_id", AlbumImageId.class);
    }

    @Override
    public AlbumImageCreated convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        AlbumImageCreated msg = new AlbumImageCreated(m, author, may);
        DBAlbumImage image = this._albumService.getDBImageById(msg.getImageId());
        DBAlbum album = this._albumService.getDBAlbumById(msg.getAlbumId());
        msg.setImageName(image != null ? image.getTitle() : "");
        msg.setAlbumName(album != null ? album.getTitle() : "");
        return msg;
    }
}

