/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.business.AlbumDeletionHandler;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlbumDeletionHandlerImpl
implements AlbumDeletionHandler {
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        ImmutableSet filteredParentIds = FluentIterable.from(parentIds).filter(GlobalId.class).toSet();
        ImmutableSet.Builder deletionBuilder = ImmutableSet.builder();
        this.addAlbumIdsForDeletion((Iterable<AlbumId>)this._albumService.getAlbumIdsByParentIds((Set<? extends GlobalId>)filteredParentIds), deletionContext, (ImmutableSet.Builder<AlbumId>)deletionBuilder);
        ImmutableSet albumIdsToDelete = deletionBuilder.build();
        this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)albumIdsToDelete, deletionContext);
        this._albumService.deleteDependentAlbums((Iterable<AlbumId>)albumIdsToDelete, (Set<? extends GlobalId>)filteredParentIds, deletionContext);
    }

    private void addAlbumIdsForDeletion(@Nonnull Iterable<AlbumId> albumIds, @Nonnull DeletionContext deletionContext, @Nonnull ImmutableSet.Builder<AlbumId> deletionBuilder) {
        for (AlbumId albumId : albumIds) {
            if (deletionContext.isItemDeleted(albumId)) continue;
            deletionContext.addDeletedItem(albumId);
            deletionContext.addServerEvent(new ItemDeletedEvent(albumId));
            deletionBuilder.add((Object)albumId);
        }
    }
}

