/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.album.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.album.business.AlbumCreatedStreamHandler;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.album.shared.model.DBAlbum;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.AlbumCreated;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="albumCreatedStreamHandler")
public class AlbumCreatedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<AlbumCreated>
implements AlbumCreatedStreamHandler {
    @Autowired
    private AlbumService _albumService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return AlbumCreatedStreamHandlerImpl.attributesToDelete(itemIds, "album_id", AlbumId.class);
    }

    @Override
    public AlbumCreated convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        AlbumId albumId = AlbumId.parse(m.getAttribute("album_id"));
        if (albumId == null) {
            return null;
        }
        AlbumCreated res = new AlbumCreated(m, author, may);
        DBAlbum album = this._albumService.getDBAlbumById(albumId);
        res.setAlbumId(albumId);
        res.setAlbumTitle(album != null ? album.getTitle() : "");
        return res;
    }
}

