/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.admin;

import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.server.business.event.FlushCacheEvent;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.ada.AdminInternalConnector;
import de.justsoftware.onx.admin.LessResourceReloadSource;
import de.justsoftware.onx.authorization.business.JustPermissionPublisher;
import de.justsoftware.onx.authorization.business.JustRolesPublisher;
import de.justsoftware.onx.chat.business.ChatServiceInternalApiConnector;
import de.justsoftware.onx.chat.business.JabberContactSyncService;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.container.business.DriveChangeVersionPublisher;
import de.justsoftware.onx.container.business.EntityAnchorPublisher;
import de.justsoftware.onx.container.business.EntityItemPublishService;
import de.justsoftware.onx.container.business.EntityPrivacySettingsPublisher;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.message.business.impl.ConversationPermissionService;
import de.justsoftware.onx.message.search.business.ChatSearchService;
import de.justsoftware.onx.news.NewsInternalApiConnector;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.person.business.PersonChangesPublisher;
import de.justsoftware.onx.person.business.PersonExternalIdPublisher;
import de.justsoftware.onx.profile.business.ProfileAttributesChangesPublisher;
import de.justsoftware.onx.profile.business.ProfileAttributesConfigPublisher;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.business.LearnToRankService;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.model.JustSearchApp;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.LearnToRankTriggerResult;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.wiki.business.WikiInternalApiConnector;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SuperAdminService
extends LessResourceReloadSource {
    private static final Logger LOG = LoggerFactory.getLogger(SuperAdminService.class);
    private final AdminInternalConnector _adminInternalConnector;
    private final MemcachedClientCache _cache;
    private final EhcacheClient _ehcacheClient;
    private final ConfigFileService _configFileService;
    private final JabberContactSyncService _jabberContactSyncService;
    private final JCEventBus _eventBus;
    private final SearchIndexService _searchIndexService;
    private final CommonSearchService _searchService;
    private final ChatSearchService _chatSearchService;
    private final DriveInternalApiConnector _driveInternalApiConnector;
    private final NewsInternalApiConnector _newsInternalApiConnector;
    private final PeopleInternalApiConnector _peopleInternalApiConnector;
    private final WikiInternalApiConnector _wikiInternalApiConnector;
    private final ChatServiceInternalApiConnector _chatServiceInternalApiConnector;
    private final PersonChangesPublisher _personChangePublisher;
    private final EntityPrivacySettingsPublisher _entityPrivacySettingsPublisher;
    private final JustRolesPublisher _justRolesPublisher;
    private final EntityAnchorPublisher _entityAnchorPublisher;
    private final EntityItemPublishService _entityItemPublishService;
    private final DriveChangeVersionPublisher _driveChangeVersionPublisher;
    private final PersonExternalIdPublisher _personExternalIdPublisher;
    private final ProfileAttributesChangesPublisher _profileAttributesChangesPublisher;
    private final ProfileAttributesConfigPublisher _profileAttributesConfigPublisher;
    private final LearnToRankService _learnToRankService;
    private final JustPermissionPublisher _permissionPublisher;
    private final PersonTenantService _personTenantService;
    private final ConversationPermissionService _conversationPermissionService;

    public SuperAdminService(AdminInternalConnector adminInternalConnector, MemcachedClientCache cache, EhcacheClient ehcacheClient, ConfigFileService configFileService, JabberContactSyncService jabberContactSyncService, JCEventBus eventBus, SearchIndexService searchIndexService, CommonSearchService searchService, ChatSearchService chatSearchService, DriveInternalApiConnector driveInternalApiConnector, NewsInternalApiConnector newsInternalApiConnector, PeopleInternalApiConnector peopleInternalApiConnector, WikiInternalApiConnector wikiInternalApiConnector, ChatServiceInternalApiConnector chatServiceInternalApiConnector, PersonChangesPublisher personChangePublisher, EntityPrivacySettingsPublisher entityPrivacySettingsPublisher, JustRolesPublisher justRolesPublisher, EntityAnchorPublisher entityAnchorPublisher, EntityItemPublishService entityItemPublishService, DriveChangeVersionPublisher driveChangeVersionPublisher, PersonExternalIdPublisher personExternalIdPublisher, ProfileAttributesChangesPublisher profileAttributesChangesPublisher, ProfileAttributesConfigPublisher profileAttributesConfigPublisher, LearnToRankService learnToRankService, JustPermissionPublisher permissionPublisher, PersonTenantService personTenantService, ConversationPermissionService conversationPermissionService) {
        this._adminInternalConnector = adminInternalConnector;
        this._cache = cache;
        this._ehcacheClient = ehcacheClient;
        this._configFileService = configFileService;
        this._jabberContactSyncService = jabberContactSyncService;
        this._eventBus = eventBus;
        this._searchIndexService = searchIndexService;
        this._searchService = searchService;
        this._chatSearchService = chatSearchService;
        this._driveInternalApiConnector = driveInternalApiConnector;
        this._newsInternalApiConnector = newsInternalApiConnector;
        this._peopleInternalApiConnector = peopleInternalApiConnector;
        this._wikiInternalApiConnector = wikiInternalApiConnector;
        this._chatServiceInternalApiConnector = chatServiceInternalApiConnector;
        this._personChangePublisher = personChangePublisher;
        this._entityPrivacySettingsPublisher = entityPrivacySettingsPublisher;
        this._justRolesPublisher = justRolesPublisher;
        this._entityAnchorPublisher = entityAnchorPublisher;
        this._entityItemPublishService = entityItemPublishService;
        this._driveChangeVersionPublisher = driveChangeVersionPublisher;
        this._personExternalIdPublisher = personExternalIdPublisher;
        this._profileAttributesChangesPublisher = profileAttributesChangesPublisher;
        this._profileAttributesConfigPublisher = profileAttributesConfigPublisher;
        this._learnToRankService = learnToRankService;
        this._permissionPublisher = permissionPublisher;
        this._personTenantService = personTenantService;
        this._conversationPermissionService = conversationPermissionService;
    }

    public void syncAllPermissions() {
        LOG.info("syncAllPermissions");
        this._adminInternalConnector.republishAllTenants();
        this.republishAllPersonTenants();
        this.syncPersonData();
        this.syncToroPermissions();
        this.syncDrivePermissions();
        this.syncWikiPermissions();
        this.syncPeoplePermissions();
        this.syncConnectPermissions();
        if (this._chatServiceInternalApiConnector.isAvailable()) {
            this.syncChatPermissions();
        }
        if (this._newsInternalApiConnector.isAvailable()) {
            this.syncNewsPermissions();
        }
        LOG.info("done");
    }

    public void syncJustPeople() {
        LOG.info("syncJustPeople");
        this.syncPersonData();
        this.republishAllPersonTenants();
        this.reindexPeopleUserGroups();
        LOG.info("done");
    }

    public void syncJustDrive() {
        LOG.info("syncJustDrive");
        this.syncDocuments();
        this.syncPrivacySettings();
        this.syncEntityItems();
        this.syncRoles();
        LOG.info("done");
    }

    public void flushCache() {
        this._cache.flush();
        this._ehcacheClient.flush();
        this._eventBus.post(FlushCacheEvent.INSTANCE);
    }

    public void reloadOverrideLess() {
        this.reloadLessResources();
    }

    public void reloadConfigFile() {
        try {
            this._configFileService.loadJuCoConfigFiles();
        }
        catch (LoadConfigFileException e) {
            throw new ServiceException(e.getMessage());
        }
    }

    public void syncAllJabberContacts() {
        this._jabberContactSyncService.markEverybodyUnsynced();
    }

    public void reindex(Set<? extends Type> searchTypes, boolean reindexAppSpecificSearches) {
        this.reindexCommon(searchTypes);
        if (reindexAppSpecificSearches) {
            this.reindexChat();
            this.reindexDrive();
            this.reindexWiki();
            this.reindexOpticonChat();
            this.reindexNews();
        } else if (searchTypes.contains(ItemType.CONVERSATION) || searchTypes.contains(ItemType.CHAT)) {
            this.reindexOpticonChat();
        }
    }

    public void reindex(FilterType filterType) {
        this._searchIndexService.fullImport(Set.of(filterType), true);
    }

    public void reindexEverything() {
        this.reindexCommon(null);
        this.reindexChat();
        this.reindexDrive();
        this.reindexWiki();
        this.reindexOpticonChat();
        this.reindexNews();
    }

    private void reindexCommon(@Nullable Set<? extends Type> searchTypes) {
        if (searchTypes == null) {
            this._searchService.deleteAllDocumentsForSearchApp(JustSearchApp.CONNECT);
            this._searchIndexService.fullImport((Set<FilterType>)this._searchService.getAllFilterTypes(), false);
        } else {
            ImmutableSet filterTypes = (ImmutableSet)searchTypes.stream().map(FilterTypes::getByType).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            if (!filterTypes.isEmpty()) {
                this._searchIndexService.fullImport((Set<FilterType>)filterTypes, true);
            }
        }
    }

    private void reindexOpticonChat() {
        if (this._chatServiceInternalApiConnector.isAvailable()) {
            this._chatServiceInternalApiConnector.reindexAll();
        }
    }

    private void reindexNews() {
        if (this._newsInternalApiConnector.isAvailable()) {
            this._newsInternalApiConnector.reindex();
        }
    }

    public void clearAndSyncConversationNodes() {
        if (this._chatServiceInternalApiConnector.isAvailable()) {
            this._chatServiceInternalApiConnector.clearAndSyncConversationNodes();
        }
    }

    private void reindexChat() {
        this._chatSearchService.fullImport(true);
    }

    public void reindexChatMessages() {
        this.reindexChat();
    }

    public void reindexDriveDocuments() {
        this.reindexDrive();
    }

    private void reindexDrive() {
        this._driveInternalApiConnector.reindexDriveDocuments();
    }

    public void syncPersonData() {
        if (!(this._personChangePublisher.ready() && this._personExternalIdPublisher.ready() && this._profileAttributesChangesPublisher.ready())) {
            throw new ServiceException("publishers are not ready");
        }
        this._personTenantService.republishAllPersonTenants();
        this._personChangePublisher.publishAllPersons();
        this._personExternalIdPublisher.publishAllMappings();
        this._profileAttributesConfigPublisher.publishDynamicAttributeConfiguration();
        this._profileAttributesChangesPublisher.publishAllForProfiles();
    }

    public void syncPrivacySettings() {
        this._entityPrivacySettingsPublisher.republishAllEntities();
    }

    public void syncRoles() {
        this._justRolesPublisher.publishAllRoles();
    }

    public void syncDriveChanges() {
        this._driveInternalApiConnector.publishAllChanges();
    }

    public void syncDrivePermissions() {
        this._driveInternalApiConnector.publishDrivePermissions();
    }

    public void syncPeoplePermissions() throws ServiceException {
        this._peopleInternalApiConnector.publishAllUserGroups();
    }

    public void syncWikiPermissions() throws ServiceException {
        this._wikiInternalApiConnector.publishAllWikiPermissions();
    }

    public void syncChatPermissions() throws ServiceException {
        this._chatServiceInternalApiConnector.publishAllPermissions();
    }

    public void syncNewsPermissions() throws ServiceException {
        this._newsInternalApiConnector.republishAllPermissions();
    }

    public void reindexWiki() throws ServiceException {
        this._wikiInternalApiConnector.reindexWiki();
    }

    public void reindexWikiContainers() throws ServiceException {
        this._wikiInternalApiConnector.reindexWikiContainers();
    }

    public void reindexWikiChapters() throws ServiceException {
        this._wikiInternalApiConnector.reindexWikiChapters();
    }

    public void reindexWikiArticles() throws ServiceException {
        this._wikiInternalApiConnector.reindexWikiArticles();
    }

    public void syncToroPermissions() {
        this._permissionPublisher.publishAllPermissions();
    }

    public void syncConnectPermissions() {
        this._conversationPermissionService.republishPermissionsForConversations();
    }

    public void republishAllPersonTenants() {
        this._personTenantService.republishAllPersonTenants();
    }

    public void runDriveHistoryCompactionJob() {
        this._driveInternalApiConnector.runDriveHistoryCompactionJob();
    }

    public void reindexPeopleUserGroups() throws ServiceException {
        this._peopleInternalApiConnector.reindexAllUserGroups();
    }

    public void syncDocuments() {
        this._driveInternalApiConnector.publishAllDocuments();
    }

    public void indexEntityAnchors() {
        this._entityAnchorPublisher.publishAllEntities();
    }

    public void syncEntityItems() {
        this._entityItemPublishService.publishAllEntities();
    }

    public void syncDriveChangeVersions() {
        this._driveChangeVersionPublisher.publishAllDriveChangeVersions();
    }

    public LearnToRankTriggerResult searchLTRTrain() throws ServiceException {
        return this._learnToRankService.startTraining();
    }

    public LearnToRankTriggerResult searchLTRReset() throws ServiceException {
        return this._learnToRankService.resetFeaturesAndModels();
    }

    public LearnToRankTriggerResult searchLTRUpdateUpcomingFeatures() throws ServiceException {
        return this._learnToRankService.updateUpcomingFeatures();
    }
}

