/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.ada;

import com.fasterxml.jackson.databind.JsonNode;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class AdminInternalConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AdminInternalConnector.class);
    private final String _adminInternalUrl;
    private final RestOperations _restOperations;

    @Autowired
    public AdminInternalConnector(@Value(value="${just-admin.internal.url}") String adminInternalUrl, @Qualifier(value="defaultRestTemplate") RestOperations restOperations) {
        this._adminInternalUrl = adminInternalUrl;
        this._restOperations = restOperations;
    }

    public ResponseEntity<JsonNode> getHealth() {
        return this._restOperations.getForEntity(this._adminInternalUrl + "/monitoring/health", JsonNode.class, new Object[0]);
    }

    public void republishAllTenants() {
        try {
            LOG.info("Send POST request to republish tenants.");
            this._restOperations.postForEntity(this._adminInternalUrl + "/republish-tenants", null, String.class, new Object[0]);
        }
        catch (RestClientException exception) {
            LOG.error("Republish-tenants failed!", (Throwable)exception);
        }
    }
}

