/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class FreemarkerLinkDirective
extends SimpleFreemarkerDirective {
    public static final FreemarkerLinkDirective INSTANCE = new FreemarkerLinkDirective();
    public static final String NAME = "a";

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException, IOException {
        final String text = FreemarkerDirectiveUtils.getNullableStringParameter("text", params, env);
        final String href = FreemarkerDirectiveUtils.getNullableStringParameter("href", params, env);
        final boolean noText = StringUtils.isBlank((String)text);
        if (StringUtils.isBlank((String)href) && noText) {
            return "";
        }
        FreemarkerRenderMode renderMode = FreemarkerDirectiveUtils.getRenderMode(env);
        return renderMode.accept(new FreemarkerRenderMode.FreemarkerRenderTypeVisitor<String>(){

            @Override
            public String visitText() {
                return noText ? " <" + href + ">" : text;
            }

            @Override
            public String visitHtml() {
                return FreemarkerLinkDirective.htmlLink(text, href);
            }
        });
    }

    @Nonnull
    private static String htmlLink(@Nullable String text, @Nullable String href) {
        String finalText;
        String string = finalText = StringUtils.isBlank((String)text) ? FreemarkerDirectiveUtils.escapeHtml(href) : text;
        if (StringUtils.isBlank((String)href)) {
            return StringUtils.defaultString((String)finalText);
        }
        return "<a href=\"" + href + "\" target=\"_blank\">" + finalText + "</a>";
    }

    @Nonnull
    public static String htmlLinkEscapeText(@Nullable String text, @Nullable String href) {
        return FreemarkerLinkDirective.htmlLink(FreemarkerDirectiveUtils.escapeHtml(StringUtils.defaultString((String)text)), href);
    }
}

