/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import com.google.common.base.Charsets;
import com.google.common.io.ByteSource;
import de.justsoftware.mail.freemarker.EmbeddedImageBuilder;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public final class FreemarkerImageDirective
extends SimpleFreemarkerDirective {
    public static final FreemarkerImageDirective INSTANCE = new FreemarkerImageDirective();
    public static final String NAME = "image";
    private static final Charset ENCODING_8BIT = Charsets.ISO_8859_1;

    @Override
    protected String loadString(Map<String, ?> params, Environment env) throws TemplateException, IOException {
        String fileName = FreemarkerDirectiveUtils.getStringParameter("file", params, env);
        String currentTemplateName = env.getTemplate().getName();
        int lastSlash = currentTemplateName.lastIndexOf(47);
        String templatePath = lastSlash == -1 ? "" : currentTemplateName.substring(0, lastSlash + 1);
        String templateNameString = TemplateCache.getFullTemplatePath((Environment)env, (String)templatePath, (String)fileName);
        Template t = env.getTemplateForInclusion(templateNameString, ENCODING_8BIT.name(), false);
        EmbeddedImageBuilder builder = EmbeddedImageBuilder.create(env, fileName);
        builder.setAttachmentData(ByteSource.wrap((byte[])t.toString().getBytes(ENCODING_8BIT)));
        return builder.buildAndReturnNewUrl();
    }
}

