/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.SimpleFreemarkerDirective;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class FreemarkerEscapeDirective
extends SimpleFreemarkerDirective {
    public static final FreemarkerEscapeDirective INSTANCE = new FreemarkerEscapeDirective();
    public static final String NAME = "escape";

    @Override
    protected String loadString(Map<String, ?> params, final Environment env) throws TemplateException, IOException {
        final boolean linebreak = Boolean.TRUE.equals(FreemarkerDirectiveUtils.getNullableBooleanParameter("br", params));
        final String value = StringUtils.remove((String)FreemarkerDirectiveUtils.getStringParameter("value", params, env), (char)'\r');
        FreemarkerRenderMode renderMode = FreemarkerDirectiveUtils.getRenderMode(env);
        return renderMode.accept(new FreemarkerRenderMode.FreemarkerRenderTypeVisitor<String>(){

            @Override
            public String visitText() {
                return FreemarkerDirectiveUtils.escapeText(env, value);
            }

            @Override
            public String visitHtml() {
                String escaped = FreemarkerDirectiveUtils.escapeHtml(value);
                return linebreak ? StringUtils.replace((String)escaped, (String)"\n", (String)"<br/>") : escaped;
            }
        });
    }
}

