/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.mail.EmailAttachment;
import de.justsoftware.mail.EmailRenderService;
import de.justsoftware.mail.RenderedEmail;
import de.justsoftware.mail.freemarker.FreemarkerDateFormatDirective;
import de.justsoftware.mail.freemarker.FreemarkerDirectiveUtils;
import de.justsoftware.mail.freemarker.FreemarkerEmailRenderServiceConfiguration;
import de.justsoftware.mail.freemarker.FreemarkerEscapeDirective;
import de.justsoftware.mail.freemarker.FreemarkerImageDirective;
import de.justsoftware.mail.freemarker.FreemarkerLinkDirective;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.IMailTemplateRenderContext;
import de.justsoftware.mail.freemarker.MailTemplateRenderContext;
import de.justsoftware.onx.common.shared.util.StringUtil;
import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTimeZone;

public class FreemarkerEmailRenderService
implements EmailRenderService {
    private final Configuration _freemarkerConfiguration = new Configuration();
    private final FreemarkerEmailRenderServiceConfiguration _configuration;

    public FreemarkerEmailRenderService(@Nonnull FreemarkerEmailRenderServiceConfiguration configuration) throws IOException {
        this._configuration = configuration;
        this._freemarkerConfiguration.setTemplateLoader(configuration.getTemplateLoader());
        this._freemarkerConfiguration.setTemplateUpdateDelay(configuration.getTemplateUpdateDelaySeconds());
        this._freemarkerConfiguration.setSharedVariable("image", (TemplateModel)FreemarkerImageDirective.INSTANCE);
        this._freemarkerConfiguration.setSharedVariable("date", (TemplateModel)FreemarkerDateFormatDirective.INSTANCE);
        this._freemarkerConfiguration.setSharedVariable("escape", (TemplateModel)FreemarkerEscapeDirective.INSTANCE);
        this._freemarkerConfiguration.setSharedVariable("a", (TemplateModel)FreemarkerLinkDirective.INSTANCE);
        this._freemarkerConfiguration.setArithmeticEngine((ArithmeticEngine)ArithmeticEngine.CONSERVATIVE_ENGINE);
        for (Map.Entry<String, ? extends TemplateDirectiveModel> directiveEntry : configuration.getDirectives().entrySet()) {
            this._freemarkerConfiguration.setSharedVariable(directiveEntry.getKey(), (TemplateModel)directiveEntry.getValue());
        }
    }

    @Override
    public RenderedEmail renderEmail(String templatePath, Object referenceData, Locale locale, DateTimeZone timeZone, Charset charset, Iterable<? extends EmailAttachment> attachments) throws EmailRenderService.EmailRenderException {
        try {
            ImmutableSet.Builder att = ImmutableSet.builder();
            if (attachments != null) {
                att.addAll(attachments);
            }
            MailTemplateRenderContext textContext = new MailTemplateRenderContext(FreemarkerRenderMode.TEXT, this._configuration.getEmbedImage(), timeZone, charset, (ImmutableSet.Builder<EmailAttachment>)att);
            String textBody = FreemarkerEmailRenderService.sanitiseText(this.loadAndRenderTemplate(locale, textContext, templatePath, referenceData));
            String htmlFileName = FreemarkerEmailRenderService.getHtmlTemplatePath(templatePath);
            MailTemplateRenderContext htmlContext = new MailTemplateRenderContext(FreemarkerRenderMode.HTML, this._configuration.getEmbedImage(), timeZone, charset, (ImmutableSet.Builder<EmailAttachment>)att);
            String htmlBody = FreemarkerEmailRenderService.sanitiseHtml(this.loadAndRenderTemplate(locale, htmlContext, htmlFileName, referenceData));
            return new RenderedEmail(textBody, htmlBody, (ImmutableSet<EmailAttachment>)att.build(), charset, templatePath);
        }
        catch (RuntimeException e) {
            throw new EmailRenderService.EmailRenderException(e);
        }
        catch (IOException e) {
            throw new EmailRenderService.EmailRenderException(e);
        }
        catch (TemplateException e) {
            throw new EmailRenderService.EmailRenderException(e);
        }
    }

    @Nonnull
    @VisibleForTesting
    static String getHtmlTemplatePath(@Nonnull String templatePath) {
        int lastDot = templatePath.lastIndexOf(46);
        if (lastDot < 0) {
            return templatePath + "_html";
        }
        return templatePath.substring(0, lastDot) + "_html" + templatePath.substring(lastDot);
    }

    @Nonnull
    private String loadAndRenderTemplate(@Nonnull Locale locale, @Nonnull IMailTemplateRenderContext context, @Nonnull String templatePath, @Nonnull Object referenceData) throws IOException, TemplateException {
        Template template = this._freemarkerConfiguration.getTemplate(templatePath, locale, Charsets.UTF_8.name());
        template.setLocale(locale);
        StringWriter writer = new StringWriter();
        Environment environment = template.createProcessingEnvironment(referenceData, (Writer)writer);
        FreemarkerDirectiveUtils.setContext(environment, context);
        environment.process();
        return writer.toString();
    }

    @Nonnull
    public static String sanitiseHtml(@Nonnull String text) {
        if (StringUtils.containsIgnoreCase((String)text, (String)"<script")) {
            throw new IllegalStateException("Script tag found in e-mail");
        }
        return StringUtil.squeezeHtml(text);
    }

    @Nonnull
    public static String sanitiseText(@Nonnull String text) {
        StringBuilder result = new StringBuilder(text.length());
        for (String line : text.split("\r\n|\n|\r")) {
            result.append(StringUtils.stripEnd((String)line, null)).append('\n');
        }
        return result.toString();
    }
}

