/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mail.freemarker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.mail.freemarker.FreemarkerRenderMode;
import de.justsoftware.mail.freemarker.IMailTemplateRenderContext;
import de.justsoftware.onx.common.shared.server.util.HTMLEscaper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

public final class FreemarkerDirectiveUtils {
    private static final String PLACEHOLDER = "pLaTzHaLtEr";
    private static final ConcurrentMap<Charset, Map<String, String>> REPLACEMENT_MAPS = Maps.newConcurrentMap();

    @Nonnull
    public static <T> T getValue(@Nonnull Class<T> clz, @Nonnull String name, @Nonnull Map<String, ?> params, @Nonnull Environment env) throws TemplateException {
        T result = FreemarkerDirectiveUtils.getNullableValue(clz, name, params, env);
        if (result == null) {
            throw new TemplateException("Paramater \"" + name + "\" is not defined", env);
        }
        return result;
    }

    @CheckForNull
    public static <T> T getNullableValue(@Nonnull Class<T> clz, @Nonnull String name, @Nonnull Map<String, ?> params, @Nonnull Environment env) throws TemplateException {
        return FreemarkerDirectiveUtils.getNullableValueRecursive(clz, name, params.get(name), env);
    }

    @CheckForNull
    public static <T> T getNullableValueRecursive(@Nonnull Class<T> clz, @Nonnull String name, @Nonnull Object o, @Nonnull Environment env) throws TemplateModelException, TemplateException {
        if (o == null) {
            return null;
        }
        if (o instanceof BeanModel) {
            return (T)((BeanModel)o).getAdaptedObject(clz);
        }
        if (o instanceof TemplateBooleanModel && clz.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(((TemplateBooleanModel)o).getAsBoolean());
        }
        if (o instanceof TemplateScalarModel && clz.isAssignableFrom(String.class)) {
            return (T)((TemplateScalarModel)o).getAsString();
        }
        if (o instanceof TemplateNumberModel) {
            return (T)((TemplateNumberModel)o).getAsNumber();
        }
        if (o instanceof TemplateSequenceModel && clz.isArray()) {
            TemplateSequenceModel seq = (TemplateSequenceModel)o;
            Object result = Array.newInstance(clz.getComponentType(), seq.size());
            for (int i = 0; i < seq.size(); ++i) {
                Array.set(result, i, FreemarkerDirectiveUtils.getNullableValueRecursive(clz.getComponentType(), name + "[" + i + "]", seq.get(i), env));
            }
            return (T)result;
        }
        if (clz.isInstance(o)) {
            return (T)o;
        }
        throw new TemplateException("Paramater \"" + name + "\" has wrong type, expected " + clz + " but was " + o.getClass(), env);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static String getStringParameter(String name, Map<String, ?> params, String defaultValue, Environment env) throws TemplateException {
        return (String)MoreObjects.firstNonNull((Object)FreemarkerDirectiveUtils.getNullableValue(String.class, name, params, env), (Object)defaultValue);
    }

    @Nonnull
    public static String getStringParameter(@Nonnull String name, @Nonnull Map<String, ?> params, @Nonnull Environment env) throws TemplateException {
        return FreemarkerDirectiveUtils.getValue(String.class, name, params, env);
    }

    @CheckForNull
    @ParametersAreNonnullByDefault
    public static String getNullableStringParameter(String name, Map<String, ?> params, Environment env) throws TemplateException {
        return FreemarkerDirectiveUtils.getNullableValue(String.class, name, params, env);
    }

    public static boolean getBooleanParameter(@Nonnull String name, @Nonnull Map<String, ?> params, @Nonnull Environment env) throws TemplateException {
        Boolean result = FreemarkerDirectiveUtils.getNullableBooleanParameter(name, params);
        if (result == null) {
            throw new TemplateException("Paramater \"" + name + "\" is not defined", env);
        }
        return result;
    }

    private static boolean isFalseString(@Nullable String s) {
        return "FALSE".equalsIgnoreCase(s) || "NO".equalsIgnoreCase(s) || "DISABLED".equalsIgnoreCase(s) || "OFF".equalsIgnoreCase(s);
    }

    private static boolean isTrueString(@Nullable String s) {
        return "TRUE".equalsIgnoreCase(s) || "YES".equalsIgnoreCase(s) || "ENABLED".equalsIgnoreCase(s) || "ON".equalsIgnoreCase(s);
    }

    @CheckForNull
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="therefore i used @CheckFroNull")
    public static Boolean getNullableBooleanParameter(@Nonnull String name, @Nonnull Map<String, ?> params) throws TemplateModelException {
        Object obj = params.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)obj).getAsBoolean();
        }
        String s = obj instanceof TemplateScalarModel ? StringUtils.trimToNull((String)((TemplateScalarModel)obj).getAsString()) : StringUtils.trimToNull((String)obj.toString());
        if (FreemarkerDirectiveUtils.isTrueString(s)) {
            return Boolean.TRUE;
        }
        if (FreemarkerDirectiveUtils.isFalseString(s)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @CheckForNull
    @ParametersAreNonnullByDefault
    public static <E extends Enum<E>> E getEnumValue(Class<E> clz, String name, Map<String, ?> params, Environment env) throws TemplateException {
        Object o = params.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof BeanModel) {
            Enum cast = (Enum)((BeanModel)o).getAdaptedObject(clz);
            return (E)cast;
        }
        if (o instanceof TemplateScalarModel) {
            return Enum.valueOf(clz, ((TemplateScalarModel)o).getAsString());
        }
        if (clz.isInstance(o)) {
            Enum cast = (Enum)o;
            return (E)cast;
        }
        throw new TemplateException("Paramater \"" + name + "\" has wrong type, expected " + clz + " but was " + o.getClass(), env);
    }

    @Nonnull
    public static IMailTemplateRenderContext getContext(@Nonnull Environment env) {
        return (IMailTemplateRenderContext)Preconditions.checkNotNull((Object)FreemarkerDirectiveUtils.getContextNullable(env));
    }

    @CheckForNull
    private static IMailTemplateRenderContext getContextNullable(@Nonnull Environment env) {
        return (IMailTemplateRenderContext)env.getCustomAttribute("mailTemplateRenderContext");
    }

    public static void setContext(@Nonnull Environment env, @Nullable IMailTemplateRenderContext context) {
        env.setCustomAttribute("mailTemplateRenderContext", (Object)context);
    }

    @Nonnull
    public static final String escape(final @Nonnull Environment env, final @Nonnull String result) throws TemplateException, IOException {
        FreemarkerRenderMode renderMode = FreemarkerDirectiveUtils.getRenderMode(env);
        return renderMode.accept(new FreemarkerRenderMode.FreemarkerRenderTypeVisitor<String>(){

            @Override
            public String visitText() {
                return FreemarkerDirectiveUtils.escapeText(env, result);
            }

            @Override
            public String visitHtml() {
                return FreemarkerDirectiveUtils.escapeHtml(result);
            }
        });
    }

    @Nonnull
    public static String escapeHtml(@Nonnull String text) {
        return HTMLEscaper.escape(text);
    }

    @Nonnull
    public static String escapeText(@Nonnull Environment env, @Nonnull String text) {
        Map<String, String> replacements = FreemarkerDirectiveUtils.getOrCreateReplacementMap(FreemarkerDirectiveUtils.getContext(env).getCharset());
        if (!replacements.isEmpty()) {
            return FreemarkerDirectiveUtils.replaceEach(text, replacements);
        }
        return text;
    }

    @Nonnull
    public static String createPlaceholder(int i) {
        return PLACEHOLDER + i + PLACEHOLDER;
    }

    @Nonnull
    public static String replaceEach(@Nonnull String s, @Nonnull Map<String, String> replacements) {
        String[] searchStrings = new String[replacements.size()];
        String[] replaceStrings = new String[replacements.size()];
        int i = 0;
        for (Map.Entry<String, String> url : replacements.entrySet()) {
            searchStrings[i] = url.getKey();
            replaceStrings[i] = url.getValue();
            ++i;
        }
        return StringUtils.replaceEach((String)s, (String[])searchStrings, (String[])replaceStrings);
    }

    @Nonnull
    public static String replacePlaceholders(@Nonnull String s, String ... replacements) {
        String[] searchStrings = new String[replacements.length];
        for (int i = 0; i < replacements.length; ++i) {
            searchStrings[i] = FreemarkerDirectiveUtils.createPlaceholder(i);
        }
        return StringUtils.replaceEach((String)s, (String[])searchStrings, (String[])replacements);
    }

    @Nonnull
    public static String replacePlaceholders(@Nonnull String s, @Nonnull Iterable<String> replacements) {
        return FreemarkerDirectiveUtils.replacePlaceholders(s, (String[])Iterables.toArray(replacements, String.class));
    }

    @Nonnull
    private static Map<String, String> getOrCreateReplacementMap(@Nonnull Charset charset) {
        Map result = (Map)REPLACEMENT_MAPS.get(charset);
        if (result != null) {
            return result;
        }
        Map<String, String> newResult = FreemarkerDirectiveUtils.createReplacementMap(charset);
        Map<String, String> existing = REPLACEMENT_MAPS.putIfAbsent(charset, newResult);
        return existing != null ? existing : newResult;
    }

    @Nonnull
    private static Map<String, String> createReplacementMap(@Nonnull Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        ConcurrentMap replacements = Maps.newConcurrentMap();
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u20ac", "EUR");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u2013", "-");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u201c", "\"");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00a8", "\"");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u201e", "\"");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00b4", "'");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00e4", "ae");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00f6", "oe");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00fc", "ue");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00df", "ss");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00c4", "Ae");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00d6", "Oe");
        FreemarkerDirectiveUtils.addReplacement(encoder, replacements, "\u00dc", "Ue");
        return replacements;
    }

    @ParametersAreNonnullByDefault
    private static void addReplacement(CharsetEncoder encoder, Map<String, String> replacements, String ch, String replacement) {
        if (!encoder.canEncode(ch)) {
            replacements.put(ch, replacement);
        }
    }

    @Nonnull
    public static FreemarkerRenderMode getRenderMode(@Nonnull Environment env) {
        IMailTemplateRenderContext context = FreemarkerDirectiveUtils.getContextNullable(env);
        if (context == null) {
            return FreemarkerRenderMode.HTML;
        }
        return context.getRenderMode();
    }
}

