/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class CachingUtil {
    public static final long CACHING_DURATION_ONE_YEAR = TimeUnit.DAYS.toMillis(365L);
    private static final String EXPIRES = "Expires";
    private static final String CACHE_CONTROL = "Cache-Control";

    public static final void setCache(HttpServletRequest request, HttpServletResponse response, long durationMillis) {
        if ("HTTP/1.1".equals(request.getProtocol())) {
            response.setHeader(CACHE_CONTROL, "max-age=" + TimeUnit.MILLISECONDS.toSeconds(durationMillis));
        }
        response.setDateHeader(EXPIRES, System.currentTimeMillis() + durationMillis);
    }

    public static final void setNoCache(HttpServletRequest request, HttpServletResponse response) {
        if (request.getProtocol().compareTo("HTTP/1.0") == 0) {
            response.setHeader("Pragma", "no-cache");
        } else if (request.getProtocol().compareTo("HTTP/1.1") == 0) {
            response.setHeader(CACHE_CONTROL, "no-cache");
        }
        response.setDateHeader(EXPIRES, 1000L);
    }

    public static final void copyCacheHeader(HttpResponse origin, HttpServletResponse target) {
        Header expires;
        Header cacheControl = origin.getFirstHeader(CACHE_CONTROL);
        if (cacheControl != null) {
            target.setHeader(CACHE_CONTROL, cacheControl.getValue());
        }
        if ((expires = origin.getFirstHeader(EXPIRES)) != null) {
            target.setHeader(EXPIRES, expires.getValue());
        }
    }
}

