/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.util;

import com.freiheit.toro.common.shared.model.LoginFooterPage;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UrlUtil {
    public static final String SEPARATOR = "/";
    public static final String GENERIC_PROFILE_PATH = "/profile";
    public static final String CONTEXT_PATH = "/toro";
    public static final String UPLOAD_CONTEXT_URL = "/toro/upload";
    public static final String VIDEO_PATH = "/video";
    public static final String VIDEO_OEMBED_PATH = "/video/oembed.json";
    public static final String VIDEO_PLAYER_PATH = "/video/player";
    public static final String VIDEO_THUMBNAIL_PATH = "/video/thumbnail";
    public static final String ENTITYUPLOADSERVICE_BASE_URL = "/entity";
    public static final String ASSETS_PATH_SEGMENT = "assets";
    public static final String RESOURCE_PATH_SEGMENT = "resource";
    public static final String RESOURCE_PATH = "/toro/resource";
    public static final String RPC_PATH = "/rpc";
    public static final String RPC_CONTEXT_PATH = "/toro/rpc";
    public static final String HTML_PATH = "/html";
    public static final String HTML_RESOURCE_URL = "/toro/resource/html";
    public static final String REST_PATH = "/rest";
    public static final String HEARTBEAT_PATH = "/rest/heartbeat";
    public static final String CHAT_AUTH_PATH_SUFFIX = "/internal/chat/auth";
    public static final String CHAT_AUTH_PATH = "/rest/internal/chat/auth";
    public static final String CHAT_IS_USER_PATH = "/rest/internal/chat/isuser";
    public static final String SSO_AUTH_PATH = "/rest/internal/sso/userAuth";
    public static final String SSO_CHECK_TOKEN_PATH = "/rest/internal/sso/checkToken";
    public static final String MONITORING_PATH = "/monitoring";
    public static final String MONITORING_QUEUES_PATH = "/monitoring/queues";
    public static final String MONITORING_MEMBER_GROUP_EXPORT = "/monitoring/membergroupexport";
    public static final String REDIRECT_SERVLET_PATH = "/redirect";
    public static final String IMPORT_PATH = "/import";
    public static final String IMPORT_CSV_UPLOAD_PATH = "/import/csv-upload";
    public static final String IMPORT_CSV_DOWNLOAD_PATH = "/import/csv-download";
    public static final String IMPORT_CSV_ACCOUNTS_DOWNLOAD_PATH = "/import/csv-accounts-download";
    public static final String EXPORT_PATH = "/export";
    public static final String EXPORT_ENTITY_NEW_ENTITY_PATH = "/export/entity/newEntity";
    public static final String EXPORT_ENTITY_MEMBER_PATH = "/export/entity/members";
    public static final String EXPORT_PLATFORM_MEMBER_PATH = "/export/platformMembers";
    public static final String EXPORT_SURVEY_RESULT_PATH = "/export/survey";
    public static final String LOGIN_PATH = "/login";
    public static final String LOGOUT_PATH = "/logout";
    public static final String LOGIN_IFRAME_PATH = "/login/show";
    public static final String NEW_LOGIN_PATH = "/login";
    public static final String NEW_LOGIN_REGISTRATION_PATH = "/registration";
    public static final String NEW_LOGIN_REGISTRATION_INVALID_HASH_LINK = "/registration/invalidHash";
    public static final String NEW_LOGIN_ACCOUNT_PATH = "/account";
    public static final String NEW_LOGIN_PASSWORD_PATH = "/account/password";
    public static final String NEW_LOGIN_REQUEST_NEW_PASSWORD_LINK = "/account/password/requestNewPassword";
    public static final String NEW_LOGIN_SET_PASSWORD_LINK = "/account/password/setNewPassword";
    public static final String NEW_LOGIN_REQUEST_NEW_PASSWORD_INVALID_LINK = "/account/password/invalidLink";
    public static final String NEW_LOGIN_REQUEST_NEW_PASSWORD_EXPIRED_LINK = "/account/password/expiredLink";
    public static final String NEW_LOGIN_REQUEST_NEW_PASSWORD_INEXISTANT_ACCOUNT = "/account/password/inexistantAccount";
    public static final String NEW_LOGIN_REQUEST_NEW_PASSWORD_BLOCKED_ACCOUNT = "/account/password/blockedAccount";
    public static final String NEW_LOGIN_NEW_MAIL_PATH = "/account/mail";
    public static final String NEW_LOGIN_NEW_MAIL_VERIFIED_SUCCESS_LINK = "/account/mail/newMailVerified";
    public static final String NEW_LOGIN_NEW_MAIL_VERIFIED_FAILED_LINK = "/account/mail/newMailFailed";
    public static final String NEW_LOGIN_ACCEPT_TERMS = "/account/acceptTerms";
    public static final String NEW_LOGIN_ACCOUNT_ACTIVATION_LINK = "/account/activation";
    public static final String NEW_LOGIN_ACCOUNT_ACTIVATION_SUCCESS_LINK = "/account/activationSuccess";
    public static final String NEW_LOGIN_ACCOUNT_ACTIVATION_FAILURE_LINK = "/account/activationFailure";
    public static final String NEW_LOGIN_ACCOUNT_ACTIVATION_BLOCKED_LINK = "/account/activationBlocked";
    public static final String NEW_LOGIN_ABOUT_PATH = "/about";
    public static final String NEW_LOGIN_TERMS = "/about/" + LoginFooterPage.TERMS;
    public static final String NEW_LOGIN_PRIVACY = "/about/" + LoginFooterPage.PRIVACY;
    public static final String NEW_LOGIN_ABOUT = "/about/" + LoginFooterPage.ABOUT;
    public static final String NEW_LOGIN_PRESS = "/about/" + LoginFooterPage.PRESS;
    public static final String NEW_LOGIN_HELP = "/about/" + LoginFooterPage.HELP;
    public static final String NEW_LOGIN_IMPRINT = "/about/" + LoginFooterPage.IMPRINT;
    public static final String NEW_LOGIN_ARTICLES_OF_ASSOCIATION = "/about/" + LoginFooterPage.ARTICLES_OF_ASSOCIATION;
    public static final String RESOURCE_HTML_PATH = "/resource/html";
    public static final String REQUEST_ACTIVATION_PATH = "/requestActivation";
    public static final String ACTIVATE_ACCOUNT_PATH = "/activateAccount";
    public static final String NEW_MAIL_PATH = "/newMail";
    public static final String REQUEST_ACTIVATION_URL = "/toro/requestActivation";
    public static final String REQUEST_NEW_PASSWORD_PATH = "/requestNewPassword";
    public static final String REQUEST_NEW_PASSWORD_URL = "/toro/requestNewPassword";
    public static final String NEW_PASSWORD_PATH = "/newPassword";
    public static final String REGISTER_PATH = "/register";
    public static final String REGISTER_PATH_TENANT = "/registerTenant";
    public static final String REGISTER_URL = "/toro/register";
    public static final String EXTERNAL_INVITATION_PATH = "/invitation";
    public static final String TERMS_PATH = "/terms";
    public static final String PRIVACY_PATH = "/privacy";
    public static final String IMPRINT_PATH = "/imprint";
    public static final String HELP_PATH = "/help";
    public static final String PRESS_PATH = "/press";
    public static final String ABOUT_PATH = "/about";
    public static final String ARTICLES_OF_ASSOCIATION_PATH = "/articlesOfAssociation";
    public static final String OUTDATED_BROWSER = "/outdatedBrowser";
    public static final String PLATFORM_VERSION_PATH = "/platformVersion";
    public static final String PRINT_PREVIEW_PATH = "/printPreview";
    public static final String PRINT_PREVIEW_URL = "/toro/printPreview";
    public static final String PRINT_PREVIEW_LOCALE_PARAM = "locale";
    public static final String PRINT_PREVIEW_VIEW_AS_ROLE_PARAM = "viewAsRole";
    public static final String PRINT_PREVIEW_CURRENT_LAYOUT_ENTITY_ID = "layoutId";
    public static final String CKEDITOR = "/ckeditor";
    public static final String CKEDITOR_UPLOAD_PATH = "/ckeditor/upload";
    public static final String ICAL_PATH = "/ical";
    private static final String BEFORE_DOMAIN = "\\b((https?)://(www.)?)";
    private static final String PATH = "(:\\d+)?(/[-a-z0-9A-Z_:@&?=+,.!/~*'%#$]*)*";
    private static final String URL_HAS_PROTOCOL_REGEXP = "([^:]+://).*";

    public static void setRemoteServiceUrl(Object remoteService, String baseUrl) {
        ((ServiceDefTarget)remoteService).setServiceEntryPoint(RPC_CONTEXT_PATH + baseUrl);
    }

    public static String generateUploadUrl(String baseUrl) {
        return UPLOAD_CONTEXT_URL + baseUrl;
    }

    public static String generateCKEditorUploadUrl(GlobalId parentId) {
        return "/toro/ckeditor/upload?parentId=" + parentId.getId() + "&parentType=" + parentId.getType();
    }

    public static String extractDomainSuffix(@Nonnull String baseUrl) {
        return baseUrl.replaceAll(BEFORE_DOMAIN, "").replaceAll(PATH, "");
    }

    public static String getEntityOverviewUrl(DBEntity entity, String basePath) {
        return basePath + "#entity." + entity.getId().getId();
    }

    public static boolean hasProtocol(@Nonnull String url) {
        return url.matches(URL_HAS_PROTOCOL_REGEXP);
    }

    @Nonnull
    public static String getSurveyExportUrl(SurveyId surveyId) {
        return "/toro/export/survey?id=" + surveyId.getId();
    }

    public static String createRegistrationPath(@Nullable String hash, @Nullable EntityId entityId) {
        if (ClientStringUtil.hasText(hash)) {
            return "/invitation/" + hash;
        }
        if (entityId != null) {
            return "/register/" + entityId.getId();
        }
        return REGISTER_PATH;
    }

    @Nonnull
    public static String getICalUrl(@Nonnull String token) {
        return "/toro/ical?cal=" + token;
    }
}

