/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.util;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T extends Comparable<T>> int nullSafeCompare(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static int nullSafeCompareString(String s1, String s2) {
        if (!ClientStringUtil.hasText(s1) && !ClientStringUtil.hasText(s2)) {
            return 0;
        }
        if (!ClientStringUtil.hasText(s1)) {
            return -1;
        }
        if (!ClientStringUtil.hasText(s2)) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="we need a way to throw NPEs in situations where fb thinks nullable but it will never happen")
    public static <T> T checkNotNull(@Nullable T reference) {
        return (T)Preconditions.checkNotNull(reference);
    }

    @CheckForNull
    public static Boolean falseToNull(@Nullable Boolean bool) {
        if (bool != null && bool.booleanValue()) {
            return Boolean.TRUE;
        }
        return null;
    }
}

