/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.util;

import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageUrlUtil {
    private static final String FILE_TYPE_PATH = "filetype/";
    private static final String DEFAULT_EXTENSION = ".png";
    private static final String DEFAULT_NAME = "default";
    private static final String DEFAULT_ENTITY_DESIGN_IMAGE_PREFIX = "default_";
    private static final String BASE_IMAGE_PATH = "images/";
    private static final String DEFAULT_IMAGE_VERSION = "10";
    private static final String DEFAULT_SUFFIX = ".png?v=10";
    private static final String LOCK_PNG = "lock.png?v=10";
    private static String _imageServer = "../../../storageserver/";

    public static void setImageServerUrl(String server) {
        _imageServer = server;
    }

    public static String appendServer(String path) {
        return _imageServer + path;
    }

    public static String getImagePath(String size, String imagePath) {
        return BASE_IMAGE_PATH + size + imagePath;
    }

    public static String getImageUrl(String size, String imagePath) {
        return ImageUrlUtil.appendServer(ImageUrlUtil.getImagePath(size, imagePath));
    }

    public static String getImagePath(ImageSize size, String imageTypePath) {
        return ImageUrlUtil.getImagePath(size.getPath(), imageTypePath);
    }

    public static String getImagePath(ImageSize size, ImageType imageType) {
        return ImageUrlUtil.getImagePath(size.getPath(), imageType.getPath());
    }

    public static String getImageUrl(ImageSize size, ImageType imageType) {
        return ImageUrlUtil.appendServer(ImageUrlUtil.getImagePath(size, imageType));
    }

    public static String getImagePath(ImageSize size, ImageType imageType, @Nullable String image) {
        return ImageUrlUtil.getImagePath(size, imageType) + ImageUrlUtil.imageOrDefault(image);
    }

    public static String getImageUrl(ImageSize size, ImageType imageType, @Nullable String image) {
        return ImageUrlUtil.appendServer(ImageUrlUtil.getImagePath(size, imageType, image));
    }

    public static String getFullFileTypeImageUrl(String imagePath) {
        return ImageUrlUtil.getImageUrl(FILE_TYPE_PATH, imagePath);
    }

    @Nonnull
    public static String imageOrDefault(@Nullable String image) {
        if (!StringUtil.isBlank(image)) {
            return image;
        }
        return "default.png?v=10";
    }

    static String entityImageOrDefault(EntityType type, String image) {
        if (!StringUtil.isBlank(image)) {
            return image;
        }
        return DEFAULT_ENTITY_DESIGN_IMAGE_PREFIX + type.getName() + DEFAULT_SUFFIX;
    }

    public static String entityNotVisibleImagePath() {
        return LOCK_PNG;
    }

    public static String getFullOriginalUserImageUrl(String image) {
        return ImageUrlUtil.getImageUrl(ImageSize.ORIGINAL, ImageType.USER_IMAGE, image);
    }

    @Nonnull
    public static String getFullSmallUserImageUrl(String image) {
        return ImageUrlUtil.getImageUrl(ImageSize.SMALL, ImageType.USER_IMAGE, image);
    }

    public static String getFullXSmallUserImageUrl(String image) {
        return ImageUrlUtil.getImageUrl(ImageSize.X_SMALL, ImageType.USER_IMAGE, image);
    }

    public static String getFullEntityImageUrl(EntityType type, ImageSize size, @Nullable String image) {
        return ImageUrlUtil.getImageUrl(size, ImageType.ENTITY_IMAGE) + ImageUrlUtil.entityImageOrDefault(type, image);
    }

    public static String getFullEntitySlideshowImageUrl(EntityType type, ImageSize size, String image) {
        return ImageUrlUtil.getImageUrl(size, ImageType.ENTITY_IMAGE) + (String)(StringUtil.isBlank(image) ? "slideshow_" + type.getName() + DEFAULT_SUFFIX : image);
    }

    public static String getFullAlbumImageUrl(ImageSize size, String image) {
        return ImageUrlUtil.getImageUrl(size, ImageType.MDL_ALBUM_IMAGE, image);
    }

    public static String getFullEntityBannerUrl(String filename) {
        if (ImageUrlUtil.isExternalEntityDesignImage(filename)) {
            return filename;
        }
        return ImageUrlUtil.getImageUrl(ImageSize.BANNER, ImageType.ENTITY_IMAGE, filename);
    }

    public static String getOriginalEntityBannerUrl(String filename) {
        if (ImageUrlUtil.isExternalEntityDesignImage(filename)) {
            return filename;
        }
        return ImageUrlUtil.getImageUrl(ImageSize.ORIGINAL, ImageType.ENTITY_IMAGE, filename);
    }

    private static boolean isExternalEntityDesignImage(@Nullable String imageFilename) {
        if (imageFilename == null) {
            return false;
        }
        String cleanedFilename = imageFilename.trim().toLowerCase();
        return cleanedFilename.startsWith("/") || cleanedFilename.contains("://");
    }

    @Nonnull
    public static String getAppSwitcherLogoUrl(@Nullable String filename) {
        if (ImageUrlUtil.isExternalEntityDesignImage(filename)) {
            return filename;
        }
        return ImageUrlUtil.getImageUrl(ImageSize.ICON_LARGE, ImageType.APP_SWITCHER_LOGO, filename + ".svg");
    }

    @Nonnull
    public static String getCustomAppSwitcherLogoUrl(@Nullable String filename) {
        return ImageUrlUtil.getImageUrl(ImageSize.ICON_LARGE, ImageType.CUSTOM_APP_SWITCHER_LOGO, filename);
    }
}

