/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.util;

import com.google.common.base.CharMatcher;
import de.justsoftware.onx.common.shared.util.StringUtil;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ClientStringUtil {
    public static final String NULL_VALUE = "00";
    public static final String NBSP = "&nbsp;";
    public static final String SPACE = " ";
    public static final String OPENING_BRACE = " (";
    public static final String CLOSING_BRACE = ")";
    private static final int MAX_TAG_WORD_LENGTH = 15;
    private static final String URL_HAS_PROTOCOL_REG = "(([^:]+://)|#).*";
    private static final String URL_DEFAULT_PROTOCOL = "http://";

    private ClientStringUtil() {
    }

    public static boolean hasText(String string) {
        return !StringUtil.isBlank(string);
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String emptyToNull(String text) {
        if (ClientStringUtil.hasText(text)) {
            return text.trim();
        }
        return null;
    }

    public static String htmlEscape(@Nonnull String string) {
        StringBuffer result = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(string.charAt(i));
                }
            }
        }
        return result.toString();
    }

    public static String defaultIfEmpty(String string, String defaultString) {
        return StringUtil.isBlank(string) ? defaultString : string;
    }

    public static String tagWithBrokenLongWords(String tag) {
        String[] strings = tag.split("[\\s\\-]");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            String trimmed = strings[i];
            if (trimmed.length() > 15) {
                for (int j = 0; j < trimmed.length(); j += 15) {
                    int endIndex = j + 15;
                    if (endIndex < trimmed.length()) {
                        result.append(trimmed.substring(j, endIndex)).append("<span class=\"INVISIBLE_WHITE_SPAN\"> </span>");
                        continue;
                    }
                    result.append(trimmed.substring(j, trimmed.length()));
                }
            } else {
                result.append(trimmed);
            }
            if (i >= strings.length - 1) continue;
            result.append(SPACE);
        }
        return result.toString();
    }

    public static String trimOrEmpty(String s) {
        return s != null ? s.trim() : "";
    }

    @CheckForNull
    public static String trimToNull(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        return result.length() > 0 ? result : null;
    }

    public static String splitStringAtCharPos(int maxLetterCount, String s, String splitString) {
        String text;
        StringBuilder result = new StringBuilder(text.substring(0, (text = s).length() > maxLetterCount ? maxLetterCount : text.length()));
        text = text.substring(Math.min(maxLetterCount, text.length()));
        while (text.length() >= maxLetterCount) {
            int whiteSpaceIdx = text.indexOf(SPACE);
            if (whiteSpaceIdx != -1 && whiteSpaceIdx < maxLetterCount) {
                result.append(text.substring(0, whiteSpaceIdx)).append(SPACE);
                text = text.substring(whiteSpaceIdx + 1);
                continue;
            }
            result.append(splitString).append(text.substring(0, maxLetterCount));
            text = text.substring(maxLetterCount);
        }
        result.append(text);
        return result.toString();
    }

    public static String toURL(@Nullable String s) {
        if (s == null) {
            return null;
        }
        String t = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"\ufeff")).trimFrom((CharSequence)s);
        if (t.isEmpty()) {
            return t;
        }
        if (!t.matches(URL_HAS_PROTOCOL_REG)) {
            return URL_DEFAULT_PROTOCOL + t;
        }
        return t;
    }
}

