/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VideolinkUtil {
    private static final String HOSTNAME = "([\\w-]+\\.)?";
    private static final String LINK_LEFT = "http://([\\w-]+\\.)?youtube\\.com/watch\\?v=";
    private static final String LINK_RIGHT = "[\\w-]+";
    private static final String LINK_PARAMS = "&.*";
    private static final Pattern PATTERN_LEFT = Pattern.compile("http://([\\w-]+\\.)?youtube\\.com/watch\\?v=");
    private static final Pattern PATTERN_ALL = Pattern.compile("http://([\\w-]+\\.)?youtube\\.com/watch\\?v=[\\w-]+(&.*)?");
    private static final Pattern PATTERN_PARAMS = Pattern.compile("&.*");
    private static final String SRC = "src=\"";
    private static final String APOSTROPH = "\"";

    public boolean isLink(String link) {
        Matcher matcher = PATTERN_ALL.matcher(link);
        return matcher.matches() || !this.extractEmbedUrl(link).equals("");
    }

    public String removeParams(String link) {
        Matcher matcher = PATTERN_PARAMS.matcher(link);
        String res = matcher.replaceFirst("");
        return res;
    }

    public String extractHash(String link) {
        Matcher matcher = PATTERN_LEFT.matcher(link);
        String res = matcher.replaceFirst("");
        return res;
    }

    public String doIt(String link) {
        return this.extractHash(this.removeParams(this.extractUrl(link)));
    }

    private String extractEmbedUrl(String embed) {
        String link = embed;
        if (link.startsWith("<object") && link.contains(SRC)) {
            int posStart = link.indexOf(SRC);
            link = link.substring(posStart + SRC.length());
            int posEnd = link.indexOf(APOSTROPH);
            link = link.substring(0, posEnd);
            return link.replace("/v/", "/watch?v=");
        }
        return "";
    }

    private String extractUrl(String link) {
        String embed = this.extractEmbedUrl(link);
        return embed.equals("") ? link : embed;
    }
}

