/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.util;

import com.google.common.base.Function;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jsoup.Jsoup;

public final class StringUtil {
    private static final String FOLDING_INDICATOR = "...";
    public static final Function<String, String> DOUBLE_QUOTER = new Function<String, String>(){

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            return "\"" + input.replaceAll("\"", "\\\\\"") + "\"";
        }
    };

    private StringUtil() {
    }

    public static final String filenameEscape(String string) {
        return string.replaceAll("[/\\\\%?*|:\"<>;,]", "-");
    }

    @Nonnull
    public static String stripHTML(@Nullable String value) {
        if (value == null) {
            return "";
        }
        return Jsoup.parse((String)value).text();
    }

    @Nonnull
    public static String reduceWhitespaces(@Nonnull String s) {
        return s.replaceAll("\\s+", " ").replaceAll("^\\s*", "");
    }

    @Nonnull
    public static String longestString(@Nullable Collection<String> strings) {
        String longest = "";
        if (strings != null) {
            for (String s : strings) {
                if (s.length() <= longest.length()) continue;
                longest = s;
            }
        }
        return longest;
    }

    @Nonnull
    public static String makeShortDescription(@Nullable String html, int maxLength) {
        if (maxLength == 0) {
            return "";
        }
        String shortDescription = StringUtil.reduceWhitespaces(StringUtil.stripHTML(html));
        if (shortDescription.length() > maxLength) {
            return shortDescription.substring(0, maxLength) + FOLDING_INDICATOR;
        }
        return shortDescription;
    }

    public static String foldText(String text, int foldTextSize) {
        int totalSize = text.length();
        if (totalSize <= foldTextSize) {
            return text;
        }
        int foldedSize = foldTextSize + StringUtil.findFirstWhitespacePosition(text.substring(foldTextSize, totalSize));
        if (foldedSize + FOLDING_INDICATOR.length() >= totalSize) {
            return text;
        }
        return text.substring(0, foldedSize) + FOLDING_INDICATOR;
    }

    private static int findFirstWhitespacePosition(String text) {
        int length = text.length();
        for (int index = 0; index < length; ++index) {
            if (!Character.isWhitespace(text.charAt(index))) continue;
            return index;
        }
        return length;
    }
}

