/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class ReflectionUtil {
    public static Collection<Method> getSetterMethods(Class<?> bean) {
        return ReflectionUtil.getGetterOrSetterMethods(bean, true, false);
    }

    public static Collection<Method> getGetterMethods(Class<?> bean, boolean declared) {
        return ReflectionUtil.getGetterOrSetterMethods(bean, false, declared);
    }

    public static Collection<Method> getGetterOrSetterMethods(Class<?> bean, boolean setter, boolean declared) {
        LinkedList<Method> res = new LinkedList<Method>();
        for (Method m : declared ? bean.getDeclaredMethods() : bean.getMethods()) {
            if (setter != Void.TYPE.equals(m.getReturnType()) || m.getParameterTypes().length != (setter ? 1 : 0) || Modifier.isStatic(m.getModifiers()) || !m.getName().startsWith(setter ? "set" : "get")) continue;
            res.add(m);
        }
        return res;
    }

    @Nonnull
    public static List<Field> getAllFields(@Nonnull Class<?> bean) {
        ArrayList<Field> result = new ArrayList<Field>();
        result.addAll(Arrays.asList(bean.getDeclaredFields()));
        for (Class<?> superclass = bean.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            result.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        return result;
    }
}

