/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.util;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class DateUtil {
    private static final DateTimeFormatter ISO_8601_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);

    private DateUtil() {
    }

    public static Date getServerDate(Date dateWithoutTimeZone, String timeZoneString) {
        Calendar result = Calendar.getInstance();
        result.clear();
        result.setTimeZone(TimeZone.getTimeZone(timeZoneString));
        result.set(1, dateWithoutTimeZone.getYear() + 1900);
        result.set(2, dateWithoutTimeZone.getMonth());
        result.set(5, dateWithoutTimeZone.getDate());
        result.set(11, dateWithoutTimeZone.getHours());
        result.set(12, dateWithoutTimeZone.getMinutes());
        result.set(13, dateWithoutTimeZone.getSeconds());
        return result.getTime();
    }

    public static Date getServerDate(Date dateWithoutTimeZone, de.justsoftware.onx.common.shared.model.TimeZone timeZone) {
        return DateUtil.getServerDate(dateWithoutTimeZone, timeZone.getGMTString(dateWithoutTimeZone));
    }

    @Nonnull
    public static DateTimeZone toDateTimeZone(@Nonnull de.justsoftware.onx.common.shared.model.TimeZone timeZone) {
        double d = (double)TimeUnit.HOURS.toMillis(1L) * timeZone.getOffset(new Date());
        return DateTimeZone.forOffsetMillis((int)((int)Math.round(d)));
    }

    @Nonnull
    public static String formatDateISO(@Nonnull Date date) {
        return ISO_8601_FORMATTER.print(date.getTime());
    }

    @CheckForNull
    public static Date normalizeDateWithoutTimezone(@Nullable DateWithoutTimezone dateWithoutTimezone, @Nullable de.justsoftware.onx.common.shared.model.TimeZone timeZone) {
        if (dateWithoutTimezone == null) {
            return null;
        }
        if (timeZone == null) {
            return new Date(dateWithoutTimezone.getTime());
        }
        int localOffset = TimeZone.getDefault().getOffset(dateWithoutTimezone.getTime());
        long timeZoneOffset = timeZone.getTimeZoneOffsetInMillis(dateWithoutTimezone);
        long offsetDiff = (long)localOffset - timeZoneOffset;
        return new Date(dateWithoutTimezone.getTime() + offsetDiff);
    }
}

