/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server.storage;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.server.storage.SaveImageResult;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.server.storage.URLImageFile;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.server.util.StorageServerUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.fileupload.FileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageServerHelper
implements StorageServerHelper {
    public static final int IMAGE_NG_LOGIN_PAGE_SIZE_X = 410;
    public static final int IMAGE_NG_LOGIN_PAGE_SIZE_Y = 50;
    public static final int IMAGE_EMAIL_HEADER_LOGO_SIZE_X = 590;
    public static final int IMAGE_ICON_LARGE_SIZE = 50;
    static final String OK_RESULT = "ok";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStorageServerHelper.class);
    private static final int IMAGE_BANNER_MAXIMUM_SIZE_X = 250;
    private static final int IMAGE_BANNER_MAXIMUM_SIZE_Y = 50;
    private static final int IMAGE_SMALL_SIZE_X = 64;
    private static final int IMAGE_SMALL_SIZE_Y = 192;
    private static final int IMAGE_X_SMALL_SIZE_X = 35;
    private static final int IMAGE_X_SMALL_SIZE_Y = 47;
    private static final int IMAGE_LARGE_SIZE_X = 224;
    private static final int IMAGE_LARGE_SIZE_Y = 672;
    private static final int IMAGE_NORMAL_SIZE_X = 64;
    private static final int IMAGE_NORMAL_SIZE_Y = 192;
    private static final int IMAGE_LOGO_SIZE_X = 64;
    private static final int IMAGE_LOGO_SIZE_Y = 192;
    private static final int IMAGE_BIG_SIZE_X = 150;
    private static final int IMAGE_BIG_SIZE_Y = 450;
    private static final int IMAGE_ICON_SIZE_X = 35;
    private static final int IMAGE_ICON_SIZE_Y = 35;
    private static final int IMAGE_LOGO_SMALL_SIZE_X = 64;
    private static final int IMAGE_LOGO_SMALL_SIZE_Y = 192;
    private static final int MAX_IMAGE_WIDTH = 1680;
    private static final int MAX_IMAGE_HEIGHT = 1050;
    protected final Settings _settings;

    AbstractStorageServerHelper(@Nonnull Settings settings) {
        this._settings = settings;
    }

    @Override
    public SaveImageResult saveFileOnStorageServer(FileItem item, String basePath, String newFilename, Collection<ImageSize> sizes) {
        return this.saveFileOnStorageServer(item, basePath, newFilename, sizes, false);
    }

    @Override
    public SaveImageResult saveFileOnStorageServer(FileItem item, String basePath, String newFilename, Collection<ImageSize> sizes, boolean squareOfImages) {
        String formatType = this.getFormatNameFromFileItem(item);
        try {
            SaveImageResult result = this.saveFileOnStorageServer(item.getInputStream(), formatType, basePath, newFilename, sizes, squareOfImages);
            if (result.isOk()) {
                item.delete();
            }
            return result;
        }
        catch (IOException e) {
            LOG.warn("io exception:", (Throwable)e);
            return new SaveImageResult(e.getMessage());
        }
    }

    @Override
    public SaveImageResult saveFileOnStorageServer(URLImageFile imageUrl, String basePath, String newFilename, Collection<ImageSize> sizes, boolean squareOfImages) {
        SaveImageResult saveImageResult;
        block8: {
            InputStream fileInputStream = imageUrl.getConnection().getInputStream();
            try {
                saveImageResult = this.saveFileOnStorageServer(fileInputStream, imageUrl.getFormatType(), basePath, newFilename, sizes, squareOfImages);
                if (fileInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("io exception:", (Throwable)e);
                    return new SaveImageResult(e.getMessage());
                }
            }
            fileInputStream.close();
        }
        return saveImageResult;
    }

    @Override
    public SaveImageResult saveFileOnStorageServer(InputStream imgInputStream, String formatTypeInput, String basePath, String newFilename, Collection<ImageSize> sizes, boolean squareOfImagess) {
        String result;
        String fullBasePath;
        String fullBasePath2;
        String result2;
        BufferedImage img;
        String formatType = formatTypeInput;
        try {
            img = Thumbnails.of((InputStream[])new InputStream[]{imgInputStream}).scale(1.0).asBufferedImage();
        }
        catch (IOException e) {
            LOG.warn("io exception:", (Throwable)e);
            return new SaveImageResult(e.getMessage());
        }
        if (img == null) {
            return new SaveImageResult("Error by file-reading. Maybe file is corrupted.");
        }
        if (formatType.equals("gif")) {
            formatType = "png";
            assert (newFilename.substring(newFilename.lastIndexOf(".")).equalsIgnoreCase(".png"));
        }
        if (sizes.contains((Object)ImageSize.ORIGINAL) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.ORIGINAL, basePath), newFilename, 1680, 1050, true)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.X_SMALL)) {
            fullBasePath2 = ImageUrlUtil.getImagePath(ImageSize.X_SMALL, basePath);
            result2 = squareOfImagess ? this.saveSquareImageFile(img, formatType, fullBasePath2, newFilename, 35) : this.saveImageFile(img, formatType, fullBasePath2, newFilename, 35, 47, false);
            if (!result2.trim().equals(OK_RESULT)) {
                return new SaveImageResult(result2);
            }
        }
        if (sizes.contains((Object)ImageSize.SMALL)) {
            fullBasePath2 = ImageUrlUtil.getImagePath(ImageSize.SMALL, basePath);
            result2 = squareOfImagess ? this.saveSquareImageFile(img, formatType, fullBasePath2, newFilename, 64) : this.saveImageFile(img, formatType, fullBasePath2, newFilename, 64, 192, false);
            if (!result2.trim().equals(OK_RESULT)) {
                return new SaveImageResult(result2);
            }
        }
        if (sizes.contains((Object)ImageSize.NORMAL) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.NORMAL, basePath), newFilename, 64, 192, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.LARGE) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.LARGE, basePath), newFilename, 224, 672, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.BIG) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.BIG, basePath), newFilename, 150, 450, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.ICON) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.ICON, basePath), newFilename, 35, 35, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.ICON_LARGE)) {
            fullBasePath = ImageUrlUtil.getImagePath(ImageSize.ICON_LARGE, basePath);
            String string = result = squareOfImagess ? this.saveSquareImageFile(img, formatType, fullBasePath, newFilename, 50) : this.saveImageFile(img, formatType, fullBasePath, newFilename, 50, 50, false);
            if (!result.trim().equals(OK_RESULT)) {
                return new SaveImageResult(result);
            }
        }
        if (sizes.contains((Object)ImageSize.ICON_SMALL) && !(result = this.saveImageFile(img, formatType, fullBasePath = ImageUrlUtil.getImagePath(ImageSize.ICON_SMALL, basePath), newFilename, this._settings.getImageIconSmallSizeX(), this._settings.getImageIconSmallSizeY(), false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result);
        }
        if (sizes.contains((Object)ImageSize.LOGO) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.LOGO, basePath), newFilename, 64, 192, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.LOGO_SMALL) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.LOGO_SMALL, basePath), newFilename, 64, 192, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.BANNER) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.BANNER, basePath), newFilename, 250, 50, true)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.ORIGINAL_UNSCALED) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.ORIGINAL_UNSCALED, basePath), newFilename)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.NG_LOGIN_PAGE_LOGO) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.NG_LOGIN_PAGE_LOGO, basePath), newFilename, 410, 50, false)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        if (sizes.contains((Object)ImageSize.EMAIL_HEADER_LOGO) && !(result2 = this.saveImageFile(img, formatType, ImageUrlUtil.getImagePath(ImageSize.EMAIL_HEADER_LOGO, basePath), newFilename, 590, Integer.MAX_VALUE, true)).trim().equals(OK_RESULT)) {
            return new SaveImageResult(result2);
        }
        return new SaveImageResult(OK_RESULT, newFilename, img.getWidth(), img.getHeight());
    }

    private String saveSquareImageFile(BufferedImage img, String formatType, String fullBasePath, String filename, int squareWidth) {
        Thumbnails.Builder toSave = Thumbnails.of((BufferedImage[])new BufferedImage[]{img}).size(squareWidth, squareWidth).crop((Position)Positions.CENTER);
        try {
            return this.saveImageFile(toSave.asBufferedImage(), formatType, fullBasePath, filename);
        }
        catch (IOException e) {
            return "Error while saving square image.";
        }
    }

    private String saveImageFile(BufferedImage img, String formatType, String fullBasePath, String filename, int scaleX, int scaleY, boolean maxScale) {
        Thumbnails.Builder toSave = Thumbnails.of((BufferedImage[])new BufferedImage[]{img});
        if (maxScale) {
            if (img.getHeight() > scaleY || img.getWidth() > scaleX) {
                try {
                    toSave.size(scaleX, scaleY);
                    toSave.keepAspectRatio(true);
                }
                catch (IllegalArgumentException e) {
                    return "Error while scaling. The image size is not allowed.";
                }
            } else {
                toSave.scale(1.0);
            }
        } else {
            toSave.size(scaleX, scaleY);
        }
        try {
            return this.saveImageFile(toSave.asBufferedImage(), formatType, fullBasePath, filename);
        }
        catch (IOException e) {
            return "Error when saving scaled image to storageserver";
        }
    }

    protected abstract String saveImageFile(BufferedImage var1, String var2, String var3, String var4);

    @Override
    public String deleteFileOnStorageServer(String basePath, String filename) {
        return this.internalDeleteFileOnStorageServer(basePath, filename, false);
    }

    @Override
    public String deleteFileOnStorageServerPermanently(String basePath, String filename) {
        return this.internalDeleteFileOnStorageServer(basePath, filename, true);
    }

    @Nonnull
    private String internalDeleteFileOnStorageServer(String basePath, String filename, boolean permanently) {
        for (ImageSize type : ImmutableSet.of((Object)((Object)ImageSize.ORIGINAL), (Object)((Object)ImageSize.X_SMALL), (Object)((Object)ImageSize.SMALL), (Object)((Object)ImageSize.NORMAL), (Object)((Object)ImageSize.LARGE), (Object)((Object)ImageSize.BIG), (Object[])new ImageSize[]{ImageSize.ICON, ImageSize.ICON_SMALL, ImageSize.BANNER})) {
            String result = permanently ? this.deleteGenericFileOnStorageServerPermanently(ImageUrlUtil.getImagePath(type, basePath), filename) : this.deleteGenericFileOnStorageServer(ImageUrlUtil.getImagePath(type, basePath), filename);
            if (result.trim().equals(OK_RESULT)) continue;
            return result;
        }
        return OK_RESULT;
    }

    @Override
    public String getFormatNameFromFileItem(FileItem item) {
        String result = StorageServerUtil.getFormatNameFromContentType(item.getContentType());
        if (result != null) {
            return result;
        }
        String filename = item.getName();
        return this.getFormatNameFromFilename(filename);
    }

    @Override
    public String getFormatNameFromFilename(String filename) {
        return filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
    }

    @Override
    public String getExtension(String filename) {
        String ext = filename.substring(filename.lastIndexOf(46)).toLowerCase();
        if (ext.equals(".gif")) {
            return ".png";
        }
        return ext;
    }
}

