/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.server;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Random;
import org.apache.commons.io.IOUtils;

public class ClientHttpPostRequest {
    private static final Random RANDOM = new Random();
    private final HttpURLConnection _connection;
    private OutputStream _os = null;
    private final String _boundary = "---------------------------" + ClientHttpPostRequest.randomString() + ClientHttpPostRequest.randomString() + ClientHttpPostRequest.randomString();

    public ClientHttpPostRequest(String urlString) throws IOException {
        this._connection = (HttpURLConnection)new URL(urlString).openConnection();
        this._connection.setDoOutput(true);
        this._connection.setDoInput(true);
        this._connection.setUseCaches(false);
        this._connection.setChunkedStreamingMode(0);
        this._connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this._boundary);
    }

    public void setRequestProperty(String key, String value) {
        this._connection.setRequestProperty(key, value);
    }

    private void connect() throws IOException {
        if (this._os == null) {
            this._os = this._connection.getOutputStream();
        }
    }

    private void write(char c) throws IOException {
        this.connect();
        this._os.write(c);
    }

    private void write(String s) throws IOException {
        this.connect();
        this._os.write(s.getBytes(Charsets.UTF_8));
    }

    private void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    private void writeln(String s) throws IOException {
        this.connect();
        this.write(s);
        this.newline();
    }

    private static String randomString() {
        return Long.toString(RANDOM.nextLong(), 36);
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this._boundary);
    }

    private void writeName(String name) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write('\"');
    }

    public void setParameter(String name, String value) throws IOException {
        this.boundary();
        this.writeName(name);
        this.newline();
        this.newline();
        this.writeln(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[500000];
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, nread);
            }
        }
        out.flush();
    }

    public void setParameter(String name, String filename, InputStream inputStream) throws IOException {
        this.boundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.writeln(type);
        this.newline();
        ClientHttpPostRequest.pipe(inputStream, this._os);
        this.newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String name, File file) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            this.setParameter(name, file.getPath(), inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
    }

    public void startRequest() throws IOException {
        this.boundary();
        this.writeln("--");
        this._os.close();
    }

    public InputStream getInputStream() throws IOException {
        return this._connection.getInputStream();
    }

    public InputStream getErrorStream() throws IOException {
        return this._connection.getErrorStream();
    }

    public int getResponseCode() throws IOException {
        return this._connection.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this._connection.getResponseMessage();
    }

    public InputStream post() throws IOException {
        this.startRequest();
        return this.getInputStream();
    }
}

