/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.shared.model;

import com.freiheit.toro.common.shared.model.ColorFormatException;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class Color
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String _red;
    private String _green;
    private String _blue;

    @Deprecated
    public Color() {
    }

    public Color(int red, int green, int blue) {
        this._red = Color.toHexString(red);
        this._green = Color.toHexString(green);
        this._blue = Color.toHexString(blue);
    }

    public Color(String color) {
        try {
            int offset = color.charAt(0) == '#' ? 1 : 0;
            int colorLength = color.substring(offset).length();
            if (colorLength < 6) {
                throw new StringIndexOutOfBoundsException(colorLength);
            }
            Integer.parseInt(color.substring(offset, offset + 6), 16);
            this._red = color.substring(offset, offset + 2);
            this._green = color.substring(offset + 2, offset + 4);
            this._blue = color.substring(offset + 4, offset + 6);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ColorFormatException("hex string too short", e);
        }
        catch (NumberFormatException e) {
            throw new ColorFormatException("not a hex string", e);
        }
    }

    public Color(Color color) {
        this._red = color._red;
        this._green = color._green;
        this._blue = color._blue;
    }

    public int getRed() {
        return Integer.parseInt(this._red, 16);
    }

    public int getGreen() {
        return Integer.parseInt(this._green, 16);
    }

    public int getBlue() {
        return Integer.parseInt(this._blue, 16);
    }

    private static String toHexString(int value) {
        return value < 16 ? "0" + Integer.toHexString(value) : Integer.toHexString(value);
    }

    @Nonnull
    public String getStyleString() {
        return "#" + this._red + this._green + this._blue;
    }

    public String toString() {
        return this.getStyleString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._red, this._green, this._blue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Color other = (Color)obj;
        return Objects.equal((Object)this._red, (Object)other._red) && Objects.equal((Object)this._green, (Object)other._green) && Objects.equal((Object)this._blue, (Object)other._blue);
    }
}

