/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.TranslationDAO;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="translationDAO")
public class IbatisTranslationDAO
implements TranslationDAO {
    private final SqlMapClient _sqlMapClient;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisTranslationDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient) {
        this._sqlMapClient = sqlMapClient;
    }

    @Override
    public String getTranslation(String original, String languageCode) {
        HashMap params = Maps.newHashMap();
        params.put("original", original);
        params.put("languageCode", languageCode);
        return (String)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "Translation.getTranslation", params);
    }
}

