/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.LanguageDAO;
import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.freiheit.toro.common.shared.model.Language;
import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class IbatisLanguageDAO
implements LanguageDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisLanguageDAO.class);
    private final SqlMapClient _sqlMapClient;

    @Autowired
    @ParametersAreNonnullByDefault
    public IbatisLanguageDAO(@Qualifier(value="sqlMapClient") SqlMapClient client) {
        this._sqlMapClient = client;
    }

    @Override
    public List<Language> getAvailableLanguages() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting all languages");
        }
        List<Language> list = IbatisDAOUtil.wrappedQueryForList(Language.class, this._sqlMapClient, "Language.getAvailableLanguages");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Languages: " + StringUtils.join(list, (String)", "));
        }
        return list;
    }

    @Override
    public Language getById(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting language " + id);
        }
        return (Language)IbatisDAOUtil.wrappedQueryForObject(this._sqlMapClient, "Language.getById", id);
    }

    @Override
    public List<Language> getAllLanguages() {
        return IbatisDAOUtil.wrappedQueryForList(Language.class, this._sqlMapClient, "Language.getAllLanguages");
    }
}

