/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.BatchStatementProcessor;
import com.freiheit.toro.common.shared.util.ObjectUtil;
import com.freiheit.toro.common.shared.util.Tuple;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.event.RowHandler;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.shared.model.Id;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public final class IbatisDAOUtil {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final Function<Iterable<? extends Id>, List<?>> IDS_TO_IBATIS_LIST = new Function<Iterable<? extends Id>, List<?>>(){

        public List<?> apply(Iterable<? extends Id> input) {
            return IbatisDAOUtil.toIbatisList(ObjectUtil.checkNotNull(input));
        }
    };
    public static final Function<Iterable<? extends Object>, List<?>> OBJECTS_TO_IBATIS_LIST = new Function<Iterable<?>, List<?>>(){

        public List<? extends Object> apply(Iterable<? extends Object> input) {
            return IbatisDAOUtil.toIbatisList(ObjectUtil.checkNotNull(input));
        }
    };
    private static final int DEFAULT_PARTITION_SIZE = 900;
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static volatile int _partitionSize = 900;

    private IbatisDAOUtil() {
    }

    public static <I> Function<Iterable<? extends I>, Map<String, ?>> createParameterFunctionForIdsWithMapData(final @Nonnull String idParamName, final @Nonnull Map<String, ?> otherParamData) {
        return new Function<Iterable<? extends I>, Map<String, ?>>(){

            public Map<String, Object> apply(Iterable<? extends I> input) {
                HashMap result = Maps.newHashMap();
                result.putAll(otherParamData);
                result.put(idParamName, IbatisDAOUtil.toIbatisList(ObjectUtil.checkNotNull(input)));
                return result;
            }
        };
    }

    public static <I extends Id> ImmutableMap<String, ?> createPartitionedParameterMapForIds(@Nonnull Function<Iterable<? extends I>, ?> parameterFunction, @Nullable Set<? extends I> ids, @Nullable ImmutableMap<String, ?> otherParamData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (otherParamData != null) {
            builder.putAll(otherParamData);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            ArrayList partitions = Lists.newArrayList();
            for (List partition : Iterables.partition(ids, (int)_partitionSize)) {
                partitions.add(parameterFunction.apply((Object)partition));
            }
            builder.put((Object)"partitions", (Object)partitions);
        }
        return builder.build();
    }

    @Nonnull
    public static <T> List<T> wrappedQueryForList(SqlMapClient client, String name, Object params) {
        try {
            List result = client.queryForList(name, params);
            return result;
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> List<T> wrappedQueryForList(SqlMapClient client, String name) {
        try {
            return client.queryForList(name);
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> ImmutableList<T> wrappedQueryForImmutableList(@Nonnull SqlMapClient client, @Nonnull String name) {
        try {
            ImmutableListBuilderRowHandler rowHandler = ImmutableListBuilderRowHandler.identity();
            client.queryWithRowHandler(name, rowHandler);
            return rowHandler.build();
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> ImmutableList<T> wrappedQueryForImmutableList(@Nonnull SqlMapClient client, @Nonnull String name, Object params) {
        try {
            ImmutableListBuilderRowHandler rowHandler = ImmutableListBuilderRowHandler.identity();
            client.queryWithRowHandler(name, params, rowHandler);
            return rowHandler.build();
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> ImmutableSet<T> wrappedQueryForImmutableSet(@Nonnull SqlMapClient client, @Nonnull String name) {
        try {
            ImmutableSetBuilderRowHandler rowHandler = new ImmutableSetBuilderRowHandler();
            client.queryWithRowHandler(name, rowHandler);
            return rowHandler.build();
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    @Nonnull
    public static <T> ImmutableSet<T> wrappedQueryForImmutableSet(@Nonnull SqlMapClient client, @Nonnull String name, Object params) {
        try {
            ImmutableSetBuilderRowHandler rowHandler = new ImmutableSetBuilderRowHandler();
            client.queryWithRowHandler(name, params, rowHandler);
            return rowHandler.build();
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> List<T> wrappedQueryForList(Class<T> typeClass, SqlMapClient client, String name) {
        try {
            return client.queryForList(name);
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> List<T> wrappedQueryForList(SqlMapClient client, String name, Object params, int skip, int max) {
        try {
            return client.queryForList(name, params, skip, max);
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <K, V> Map<K, V> wrappedQueryForMap(SqlMapClient client, String queryName, Object params, String keyName, String valueName) {
        try {
            Map queryForMap = client.queryForMap(queryName, params, keyName, valueName);
            return queryForMap;
        }
        catch (SQLException e) {
            throw new DAOException("select", queryName, e);
        }
    }

    public static <K, V> Map<K, V> wrappedQueryForMap(SqlMapClient client, String queryName, Object params, String keyName) {
        try {
            Map queryForMap = client.queryForMap(queryName, params, keyName);
            return queryForMap;
        }
        catch (SQLException e) {
            throw new DAOException("select", queryName, e);
        }
    }

    @Nonnull
    public static <K, V, I> ImmutableMap<K, V> wrappedPartitionQueryForMap(@Nonnull SqlMapClient client, @Nonnull String queryName, @Nonnull String keyName, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQueryForMap(client, queryName, keyName, null, ids, parameterFunction);
    }

    @Nonnull
    public static <K, V, I> ImmutableMap<K, V> wrappedPartitionQueryForMap(@Nonnull SqlMapClient client, @Nonnull String queryName, @Nonnull String keyName, @Nullable String valueName, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQuery(client, queryName, ids, ImmutableMapBuilderRowHandler.forProperties(keyName, valueName), parameterFunction).build();
    }

    public static <T> T wrappedQueryForObject(SqlMapClient client, String name, Object params) {
        try {
            Object result = client.queryForObject(name, params);
            return (T)result;
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> T wrappedQueryForObject(SqlMapClient client, String name) {
        try {
            Object result = client.queryForObject(name);
            return (T)result;
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    public static <T> T wrappedInsert(SqlMapClient client, String name, Object params) {
        try {
            Object result = client.insert(name, params);
            return (T)result;
        }
        catch (SQLException e) {
            throw new DAOException("insert", name, e);
        }
    }

    public static int wrappedUpdate(SqlMapClient client, String name, Object params) {
        try {
            return client.update(name, params);
        }
        catch (SQLException e) {
            throw new DAOException("update", name, e);
        }
    }

    public static <I> int wrappedPartitionUpdate(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        int updatedRows = 0;
        if (!CollectionUtils.isEmpty(ids)) {
            try {
                for (Iterable partition : Iterables.partition(ids, (int)_partitionSize)) {
                    updatedRows += client.update(name, parameterFunction.apply((Object)partition));
                }
            }
            catch (SQLException e) {
                throw new DAOException("update", name, e);
            }
        }
        return updatedRows;
    }

    public static <I> void wrappedPartitionInsert(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Iterable<? extends I> objects, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        if (!CollectionUtil.isEmpty(objects)) {
            try {
                for (Iterable partition : Iterables.partition(objects, (int)_partitionSize)) {
                    client.insert(name, parameterFunction.apply((Object)partition));
                }
            }
            catch (SQLException e) {
                throw new DAOException("insert", name, e);
            }
        }
    }

    public static void partitionOperation(@Nonnull String key1, @Nullable Set<?> ids1, @Nonnull String key2, @Nullable Set<?> ids2, @Nonnull PartitionCallback callback) {
        if (CollectionUtils.isEmpty(ids1) || CollectionUtils.isEmpty(ids2)) {
            return;
        }
        try {
            for (Iterable partition1 : Iterables.partition(ids1, (int)_partitionSize)) {
                for (Iterable partition2 : Iterables.partition(ids2, (int)_partitionSize)) {
                    HashMap params = Maps.newHashMap();
                    params.put(key1, IbatisDAOUtil.toIbatisList(partition1));
                    params.put(key2, IbatisDAOUtil.toIbatisList(partition2));
                    callback.apply(params);
                }
            }
        }
        catch (SQLException e) {
            throw new DAOException("partition operation failed", e);
        }
    }

    public static int wrappedDelete(SqlMapClient client, String name) {
        try {
            return client.delete(name);
        }
        catch (SQLException e) {
            throw new DAOException("delete", name, e);
        }
    }

    public static int wrappedDelete(SqlMapClient client, String name, Object params) {
        try {
            return client.delete(name, params);
        }
        catch (SQLException e) {
            throw new DAOException("delete", name, e);
        }
    }

    public static Map<String, Object> toParamMapByType(Object ... objects) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Object object : objects) {
            String key = StringUtils.uncapitalize((String)object.getClass().getSimpleName());
            Object uniqueKey = key;
            int i = 2;
            while (params.containsKey(uniqueKey)) {
                uniqueKey = key + i++;
            }
            params.put((String)uniqueKey, object);
        }
        return params;
    }

    @Nonnull
    public static <K, V, I> ImmutableListMultimap<K, V> wrappedPartitionQueryForMultimap(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String keyColumn, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQueryForMultimap(client, name, keyColumn, null, ids, parameterFunction);
    }

    @Nonnull
    public static <K, V, I> ImmutableListMultimap<K, V> wrappedPartitionQueryForMultimap(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String keyColumn, @Nullable String valueColumn, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        IbatisDAOUtil.wrappedPartitionQuery(client, name, ids, new MultiMapRowHandler(IbatisDAOUtil.singlePropertyFunction(keyColumn), builder, valueColumn), parameterFunction);
        return builder.build();
    }

    @Nonnull
    public static <K, V, I> ImmutableSetMultimap<K, V> wrappedPartitionQueryForSetMultimap(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String keyColumn, @Nullable String valueColumn, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        IbatisDAOUtil.wrappedPartitionQuery(client, name, ids, new MultiMapRowHandler(IbatisDAOUtil.singlePropertyFunction(keyColumn), builder, valueColumn), parameterFunction);
        return builder.build();
    }

    @Nonnull
    private static <K, V, B extends ImmutableMultimap.Builder<K, V>> B wrappedQueryForMultimapInternal(@Nonnull B builder, @Nonnull SqlMapClient client, @Nonnull String name, @Nonnull Function<Object, K> keyFunction, @Nullable String valueColumn, @Nullable Object params) {
        try {
            client.queryWithRowHandler(name, params, new MultiMapRowHandler(keyFunction, builder, valueColumn));
            return builder;
        }
        catch (SQLException e) {
            throw new DAOException("select", name, e);
        }
    }

    @Nonnull
    public static <K> Function<Object, K> singlePropertyFunction(final @Nullable String propertyName) {
        return new Function<Object, K>(){

            public K apply(Object input) {
                return IbatisDAOUtil.probe(input, propertyName);
            }
        };
    }

    @Nonnull
    public static <K, V> ImmutableSetMultimap<K, V> wrappedQueryForSetMultiMap(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String keyColumn, @Nullable String valueColumn, @Nullable Object params) {
        return IbatisDAOUtil.wrappedQueryForSetMultiMap(client, name, IbatisDAOUtil.singlePropertyFunction(keyColumn), valueColumn, params);
    }

    @Nonnull
    public static <K, V> ImmutableSetMultimap<K, V> wrappedQueryForSetMultiMap(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull Function<Object, K> keyFunction, @Nullable String valueColumn, @Nullable Object params) {
        return IbatisDAOUtil.wrappedQueryForMultimapInternal(ImmutableSetMultimap.builder(), client, name, keyFunction, valueColumn, params).build();
    }

    @Nonnull
    public static <I, R, C, V> ImmutableTable<R, C, V> wrappedPartitionQueryForTable(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String rowColumn, @Nonnull String colColumn, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQueryForTable(client, name, rowColumn, colColumn, null, ids, parameterFunction);
    }

    @Nonnull
    public static <I, R, C, V> ImmutableTable<R, C, V> wrappedPartitionQueryForTable(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull String rowColumn, @Nonnull String colColumn, @Nullable String valColumn, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQueryForTable(client, name, IbatisDAOUtil.singlePropertyFunction(rowColumn), IbatisDAOUtil.singlePropertyFunction(colColumn), IbatisDAOUtil.singlePropertyFunction(valColumn), ids, parameterFunction);
    }

    @Nonnull
    public static <I, R, C, V> ImmutableTable<R, C, V> wrappedPartitionQueryForTable(@Nonnull SqlMapClient client, @Nonnull String name, @Nonnull Function<Object, R> rowFunction, @Nonnull Function<Object, C> colFunction, @Nonnull Function<Object, V> valFunction, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQuery(client, name, ids, new TableRowHandler<R, C, V>(rowFunction, colFunction, valFunction), parameterFunction).build();
    }

    public static <T> int executeInBatch(@Nonnull SqlMapClient client, @Nonnull List<T> list, int maxBatchSize, @Nonnull BatchStatementProcessor<T> creator) {
        int result = 0;
        for (List partition : Lists.partition(list, (int)maxBatchSize)) {
            try {
                client.startBatch();
                for (Object t : partition) {
                    creator.process(client, t);
                }
                result += client.executeBatch();
            }
            catch (SQLException e) {
                throw new DAOException("Error execute in batch", e);
            }
        }
        return result;
    }

    public static <T, K> int executeInBatch(@Nonnull SqlMapClient client, @Nonnull List<T> list1, @Nonnull List<K> list2, int maxBatchSize, @Nonnull BatchStatementProcessor<Tuple<T, K>> creator) {
        ArrayList<Tuple<T, K>> list = new ArrayList<Tuple<T, K>>(list1.size() * list2.size());
        for (T item1 : list1) {
            for (K item2 : list2) {
                list.add(new Tuple<T, K>(item1, item2));
            }
        }
        return IbatisDAOUtil.executeInBatch(client, list, maxBatchSize, creator);
    }

    @Nonnull
    public static <T> List<T> toIbatisList(@Nonnull Iterable<T> l) {
        if (l instanceof ArrayList) {
            return (ArrayList)l;
        }
        if (l instanceof ImmutableCollection) {
            return ((ImmutableCollection)l).asList();
        }
        return Lists.newArrayList(l);
    }

    @CheckForNull
    public static <T> T probe(@Nullable Object input, @Nullable String key) {
        Object result;
        Object cast = result = input == null || key == null ? input : PROBE.getObject(input, key);
        return (T)cast;
    }

    @Nonnull
    public static <I, T> ImmutableList<T> wrappedPartitionQueryForImmutableList(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQuery(client, name, ids, ImmutableListBuilderRowHandler.identity(), parameterFunction).build();
    }

    @Nonnull
    public static <I, T> ImmutableSet<T> wrappedPartitionQueryForImmutableSet(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        return IbatisDAOUtil.wrappedPartitionQuery(client, name, ids, new ImmutableSetBuilderRowHandler(), parameterFunction).build();
    }

    @Nonnull
    public static <I, T extends RowHandler> T wrappedPartitionQuery(@Nonnull SqlMapClient client, @Nonnull String queryName, @Nullable Set<? extends I> ids, @Nonnull T rowHandler, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        if (!CollectionUtils.isEmpty(ids)) {
            try {
                for (Iterable partition : Iterables.partition(ids, (int)_partitionSize)) {
                    client.queryWithRowHandler(queryName, parameterFunction.apply((Object)partition), rowHandler);
                }
            }
            catch (SQLException e) {
                throw new DAOException("select", queryName, e);
            }
        }
        return rowHandler;
    }

    public static <I> int wrappedPartitionDelete(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        int totalDeleted = 0;
        if (!CollectionUtils.isEmpty(ids)) {
            try {
                for (Iterable partition : Iterables.partition(ids, (int)_partitionSize)) {
                    totalDeleted += client.delete(name, parameterFunction.apply((Object)partition));
                }
            }
            catch (SQLException e) {
                throw new DAOException("delete", name, e);
            }
        }
        return totalDeleted;
    }

    public static <I> int wrappedPartitionQueryForCount(@Nonnull SqlMapClient client, @Nonnull String name, @Nullable Set<? extends I> ids, @Nonnull Function<Iterable<? extends I>, ?> parameterFunction) {
        int count = 0;
        if (!CollectionUtils.isEmpty(ids)) {
            for (Iterable partition : Iterables.partition(ids, (int)_partitionSize)) {
                Object object = IbatisDAOUtil.wrappedQueryForObject(client, name, parameterFunction.apply((Object)partition));
                if (!(object instanceof Integer)) {
                    throw new DAOException("this query \"" + name + "\" needs resultClass=\"Integer\"!");
                }
                Integer partitionedCount = (Integer)object;
                count += partitionedCount.intValue();
            }
        }
        return count;
    }

    public static void setPartitionSize(int partitionSize) {
        _partitionSize = partitionSize;
    }

    public static void resetPartitionSize() {
        _partitionSize = 1000;
    }

    private static final class TableRowHandler<R, C, V>
    implements RowHandler {
        private final ImmutableTable.Builder<R, C, V> _builder = ImmutableTable.builder();
        private final Function<Object, R> _rowFunction;
        private final Function<Object, C> _colFunction;
        private final Function<Object, V> _valFunction;

        public TableRowHandler(@Nonnull Function<Object, R> rowFunction, @Nonnull Function<Object, C> colFunction, @Nonnull Function<Object, V> valFunction) {
            this._rowFunction = rowFunction;
            this._colFunction = colFunction;
            this._valFunction = valFunction;
        }

        public ImmutableTable<R, C, V> build() {
            return this._builder.build();
        }

        public void handleRow(Object valueObject) {
            if (valueObject != null) {
                Object row = this._rowFunction.apply(valueObject);
                Object col = this._colFunction.apply(valueObject);
                Object val = this._valFunction.apply(valueObject);
                if (row != null && col != null && val != null) {
                    this._builder.put(row, col, val);
                }
            }
        }
    }

    public static interface PartitionCallback {
        @Nonnull
        public void apply(HashMap<String, Object> var1) throws SQLException;
    }

    @ParametersAreNonnullByDefault
    public static final class ImmutableMapBuilderRowHandler<D, K, V>
    implements TypedRowHandler<D> {
        private final Function<D, K> _keyFunction;
        private final Function<D, V> _valueFunction;
        private final ImmutableMap.Builder<K, V> _builder = ImmutableMap.builder();

        private ImmutableMapBuilderRowHandler(Function<D, K> keyFunction, Function<D, V> valueFunction) {
            this._keyFunction = keyFunction;
            this._valueFunction = valueFunction;
        }

        public static <K, V> ImmutableMapBuilderRowHandler<Object, K, V> forProperties(String keyName, @Nullable String valueName) {
            return ImmutableMapBuilderRowHandler.forFunctions(IbatisDAOUtil.singlePropertyFunction(keyName), IbatisDAOUtil.singlePropertyFunction(valueName));
        }

        public static <D, K, V> ImmutableMapBuilderRowHandler<D, K, V> forFunctions(Function<D, K> keyFunction, Function<D, V> valueFunction) {
            return new ImmutableMapBuilderRowHandler<D, K, V>(keyFunction, valueFunction);
        }

        @Override
        public void handleTypedRow(D input) {
            Object key = this._keyFunction.apply(input);
            Object value = this._valueFunction.apply(input);
            if (key != null && value != null) {
                this._builder.put(key, value);
            }
        }

        @Nonnull
        public ImmutableMap<K, V> build() {
            return this._builder.build();
        }
    }

    private static final class ImmutableSetBuilderRowHandler<T>
    implements TypedRowHandler<T> {
        private final ImmutableSet.Builder<T> _builder = ImmutableSet.builder();

        private ImmutableSetBuilderRowHandler() {
        }

        @Override
        public void handleTypedRow(T value) {
            if (value != null) {
                this._builder.add(value);
            }
        }

        @Nonnull
        ImmutableSet<T> build() {
            return this._builder.build();
        }
    }

    @FunctionalInterface
    public static interface TypedRowHandler<T>
    extends RowHandler {
        default public void handleRow(Object valueObject) {
            Object value = valueObject;
            this.handleTypedRow(value);
        }

        public void handleTypedRow(T var1);
    }

    public static final class ImmutableListBuilderRowHandler<D, T>
    implements TypedRowHandler<D> {
        private final Function<D, T> _f;
        private final ImmutableList.Builder<T> _builder = ImmutableList.builder();

        private ImmutableListBuilderRowHandler(@Nonnull Function<D, T> f) {
            this._f = f;
        }

        @Override
        public void handleTypedRow(D value) {
            Object t = this._f.apply(value);
            if (t != null) {
                this._builder.add(t);
            }
        }

        @Nonnull
        public ImmutableList<T> build() {
            return this._builder.build();
        }

        public static <D, T> ImmutableListBuilderRowHandler<D, T> forFunction(Function<D, T> f) {
            return new ImmutableListBuilderRowHandler<D, T>(f);
        }

        public static <T> ImmutableListBuilderRowHandler<T, T> identity() {
            return ImmutableListBuilderRowHandler.forFunction(Functions.identity());
        }
    }

    private static final class MultiMapRowHandler<K, V, B extends ImmutableMultimap.Builder<K, V>>
    implements RowHandler {
        private final Function<Object, K> _keyFunction;
        private final B _builder;
        private final String _valueColumn;

        private MultiMapRowHandler(Function<Object, K> keyFunction, B builder, String valueColumn) {
            this._keyFunction = keyFunction;
            this._builder = builder;
            this._valueColumn = valueColumn;
        }

        public void handleRow(Object valueObject) {
            if (valueObject != null) {
                Object value;
                Object key = this._keyFunction.apply(valueObject);
                Object object = value = this._valueColumn != null ? PROBE.getObject(valueObject, this._valueColumn) : valueObject;
                if (key != null && value != null) {
                    this._builder.put(key, value);
                }
            }
        }
    }
}

