/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.common.business.LanguageService;
import com.freiheit.toro.common.business.TranslationManager;
import com.freiheit.toro.common.integration.persistence.LanguageDAO;
import com.freiheit.toro.common.shared.model.Language;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LanguageServiceImpl
implements LanguageService {
    private static final String CACHE_KEY_AVAILABLE_LANGUAGES = "Avail";
    private static final String LANGUAGE_ALL = "LanguageAll";
    private static final String CACHE_KEY_AVAILABLE_LANGUAGES_CODE = "AvailableCode";
    private final EhcacheClient _cache;
    private final LanguageDAO _languageDAO;
    private final TranslationManager _translationManager;
    private final Settings _settings;

    @Autowired
    @ParametersAreNonnullByDefault
    public LanguageServiceImpl(EhcacheClient cache, LanguageDAO languageDAO, Settings settings, TranslationManager translationManager) {
        this._cache = cache;
        this._languageDAO = languageDAO;
        this._settings = settings;
        this._translationManager = translationManager;
    }

    @Override
    public List<Language> getAvailableLanguages(String localeId) {
        List<Language> cached = (List<Language>)this._cache.get(LanguageServiceCacheName.GENERIC, CACHE_KEY_AVAILABLE_LANGUAGES);
        if (cached == null) {
            cached = this._languageDAO.getAvailableLanguages();
            this._cache.add(LanguageServiceCacheName.GENERIC, CACHE_KEY_AVAILABLE_LANGUAGES, cached);
        }
        return this._translationManager.translateList(cached, localeId);
    }

    @Override
    public List<Language> getAllLanguages(String localeId) {
        List<Language> cached = (List<Language>)this._cache.get(LanguageServiceCacheName.GENERIC, LANGUAGE_ALL);
        if (cached == null) {
            cached = this._languageDAO.getAllLanguages();
            this._cache.add(LanguageServiceCacheName.GENERIC, LANGUAGE_ALL, cached);
        }
        return this._translationManager.translateList(cached, localeId);
    }

    @Override
    public ImmutableSet<String> getAvailableLanguageCode() {
        ImmutableSet availableLanguageCodes = (ImmutableSet)this._cache.get(LanguageServiceCacheName.GENERIC, CACHE_KEY_AVAILABLE_LANGUAGES_CODE);
        if (availableLanguageCodes == null) {
            List<Language> availableLanguages = this._languageDAO.getAvailableLanguages();
            ImmutableSet.Builder newLanguageCodes = ImmutableSet.builder();
            for (Language l : availableLanguages) {
                newLanguageCodes.add((Object)l.getId());
            }
            availableLanguageCodes = newLanguageCodes.build();
            this._cache.add(LanguageServiceCacheName.GENERIC, CACHE_KEY_AVAILABLE_LANGUAGES_CODE, availableLanguageCodes);
        }
        return ImmutableSet.builder().add((Object)this._settings.defaultLanguage()).addAll((Iterable)availableLanguageCodes).build();
    }

    public static enum LanguageServiceCacheName implements EhCacheName
    {
        GENERIC("Language.Generic");

        private final String _cacheName;

        private LanguageServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }

        @Override
        public int getMaxElements() {
            return 10;
        }

        @Override
        public long getTimeToLiveSeconds() {
            return CacheClient.LONG_LIFETIME;
        }
    }
}

