/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache.ehcache;

import com.freiheit.toro.cache.TrueFuture;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@ParametersAreNonnullByDefault
public class TransactionalEhcacheClient
implements EhcacheClient {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalEhcacheClient.class);
    @VisibleForTesting
    final EhcacheClient _delegate;
    private final ThreadLocal<ThreadLocalWrapper> _transactionDelegate = ThreadLocal.withInitial(() -> new ThreadLocalWrapper());

    public TransactionalEhcacheClient(EhcacheClient delegate) {
        this._delegate = delegate;
    }

    @VisibleForTesting
    void registerSynchronization(TransactionSynchronizationAdapter transactionSynchronizationAdapter) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionSynchronizationAdapter);
    }

    @Nonnull
    @VisibleForTesting
    EhcacheClient delegate() {
        return this.isInTransaction() ? (EhcacheClient)this._transactionDelegate.get() : this._delegate;
    }

    @VisibleForTesting
    boolean isInTransaction() {
        return TransactionSynchronizationManager.isSynchronizationActive();
    }

    @Override
    public <T> T get(EhCacheName cacheName, String key) {
        return this.delegate().get(cacheName, key);
    }

    @Override
    public <T> Map<String, T> getBulk(EhCacheName cacheName, Collection<String> keys) {
        return this.delegate().getBulk(cacheName, keys);
    }

    @Override
    public Future<Boolean> add(EhCacheName cacheName, String key, Object o) {
        return this.delegate().add(cacheName, key, o);
    }

    @Override
    public Future<Boolean> delete(EhCacheName cacheName, String key) {
        return this.delegate().delete(cacheName, key);
    }

    @Override
    public Future<Boolean> deleteKeys(EhCacheName cacheName, Iterable<String> stringKeys) {
        return this.delegate().deleteKeys(cacheName, stringKeys);
    }

    @Override
    public void deleteAll(EhCacheName cacheName) {
        this.delegate().deleteAll(cacheName);
    }

    @Override
    public Future<Boolean> flush() {
        return this.delegate().flush();
    }

    private class ThreadLocalWrapper
    implements EhcacheClient {
        private final SetMultimap<EhCacheName, String> _invalidatedKeys = HashMultimap.create();
        private final Set<EhCacheName> _invalidatedCaches = new HashSet<EhCacheName>();
        private boolean _flushed = false;

        private ThreadLocalWrapper() {
            TransactionalEhcacheClient.this.registerSynchronization(new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    LOG.debug("after commit {} {}", ThreadLocalWrapper.this._invalidatedKeys, ThreadLocalWrapper.this._invalidatedCaches);
                    if (ThreadLocalWrapper.this._flushed) {
                        TransactionalEhcacheClient.this._delegate.flush();
                    } else {
                        ThreadLocalWrapper.this._invalidatedKeys.asMap().forEach((cacheName, keys) -> {
                            if (!ThreadLocalWrapper.this._invalidatedCaches.contains(cacheName)) {
                                TransactionalEhcacheClient.this._delegate.deleteKeys(cacheName, (Iterable<String>)keys);
                            }
                        });
                        ThreadLocalWrapper.this._invalidatedCaches.forEach(TransactionalEhcacheClient.this._delegate::deleteAll);
                    }
                }

                public void afterCompletion(int status) {
                    TransactionalEhcacheClient.this._transactionDelegate.remove();
                }
            });
        }

        private boolean isInvalidated(EhCacheName cacheName) {
            return this._flushed || this._invalidatedCaches.contains(cacheName);
        }

        private boolean isInvalidated(EhCacheName cacheName, String key) {
            return this.isInvalidated(cacheName) || this._invalidatedKeys.containsEntry((Object)cacheName, (Object)key);
        }

        @Override
        public <T> T get(EhCacheName cacheName, String key) {
            return this.isInvalidated(cacheName, key) ? null : (T)TransactionalEhcacheClient.this._delegate.get(cacheName, key);
        }

        @Override
        public <T> Map<String, T> getBulk(EhCacheName cacheName, Collection<String> keys) {
            if (this.isInvalidated(cacheName)) {
                return ImmutableMap.of();
            }
            Set invalidatedKeys = this._invalidatedKeys.get((Object)cacheName);
            Sets.SetView remainingKeys = invalidatedKeys.isEmpty() ? keys : Sets.difference((Set)ImmutableSet.copyOf(keys), (Set)invalidatedKeys);
            return TransactionalEhcacheClient.this._delegate.getBulk(cacheName, (Collection<String>)remainingKeys);
        }

        @Override
        public Future<Boolean> add(EhCacheName cacheName, String key, Object o) {
            return this.isInvalidated(cacheName, key) ? TrueFuture.INSTANCE : TransactionalEhcacheClient.this._delegate.add(cacheName, key, o);
        }

        @Override
        public Future<Boolean> delete(EhCacheName cacheName, String key) {
            if (!this.isInvalidated(cacheName)) {
                this._invalidatedKeys.put((Object)cacheName, (Object)key);
            }
            return TrueFuture.INSTANCE;
        }

        @Override
        public Future<Boolean> deleteKeys(EhCacheName cacheName, Iterable<String> keys) {
            if (!this.isInvalidated(cacheName)) {
                this._invalidatedKeys.putAll((Object)cacheName, keys);
            }
            return TrueFuture.INSTANCE;
        }

        @Override
        public void deleteAll(EhCacheName cacheName) {
            this._invalidatedCaches.add(cacheName);
            this._invalidatedKeys.removeAll((Object)cacheName);
        }

        @Override
        public Future<Boolean> flush() {
            this._flushed = true;
            this._invalidatedCaches.clear();
            this._invalidatedKeys.clear();
            return TrueFuture.INSTANCE;
        }
    }
}

