/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache.ehcache;

import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.TrueFuture;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.freiheit.toro.cache.ehcache.EhcacheClientConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerListenerFactory;
import net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.RMICacheReplicatorFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public class EhcacheClientImpl
implements EhcacheClient,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(EhcacheClientImpl.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private final CacheManager _cacheManager;
    private final ImmutableMap<EhCacheName, Ehcache> _caches;

    @Autowired
    public EhcacheClientImpl(@Nonnull EhcacheClientConfiguration configuration) throws UnknownHostException {
        this._cacheManager = CacheManager.create((Configuration)EhcacheClientImpl.createConfiguration(configuration));
        if (INSTANCE_COUNT.incrementAndGet() > 1) {
            LOG.warn("There are more than one instance of this class registered! This could be a problem in production environments!");
        }
        this._caches = this.registerCaches(this._cacheManager, configuration);
    }

    private ImmutableMap<EhCacheName, Ehcache> registerCaches(CacheManager cacheManager, EhcacheClientConfiguration configuration) throws UnknownHostException {
        ImmutableMap.Builder result = ImmutableMap.builder();
        Set<String> peers = EhcacheClientImpl.getFilteredPeers(configuration);
        CacheManagerPeerProvider peerProvider = cacheManager.getCacheManagerPeerProvider("RMI");
        Iterable<? extends EhCacheName> cacheNames = configuration.getCacheNames();
        this.checkUniqueCacheNames(cacheNames);
        for (EhCacheName ehCacheName : cacheNames) {
            result.put((Object)ehCacheName, (Object)this.createCache(ehCacheName));
            for (String peer : peers) {
                String url = peer + "/" + ehCacheName.getCacheName();
                LOG.info("registering peer URL \"" + url + "\"");
                peerProvider.registerPeer("//" + url);
            }
        }
        return result.build();
    }

    private void checkUniqueCacheNames(@Nonnull Iterable<? extends EhCacheName> names) {
        try {
            Maps.uniqueIndex(names, CacheName.TO_CACHE_NAME);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cache names are not unique!", e);
        }
    }

    @Nonnull
    @VisibleForTesting
    static Set<String> getFilteredPeers(@Nonnull EhcacheClientConfiguration configuration) throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        String[] localHostNames = new String[]{localHost.getHostAddress(), localHost.getCanonicalHostName(), localHost.getHostName(), "localhost", "127.0.0.1", configuration.getHost()};
        HashSet result = Sets.newHashSet(configuration.getPeers());
        Integer port = configuration.getPort();
        if (result.isEmpty() || port == null) {
            return ImmutableSet.of();
        }
        for (String host : localHostNames) {
            if (!StringUtils.isNotBlank((String)host)) continue;
            result.remove(host + ":" + port);
        }
        return result;
    }

    private static Configuration createConfiguration(EhcacheClientConfiguration configuration) {
        Integer port = configuration.getPort();
        Configuration config = new Configuration().name(String.valueOf(port));
        config.setMaxBytesLocalOffHeap((Long)null);
        config.setMaxBytesLocalDisk((Long)null);
        config.setMaxBytesLocalHeap((Long)null);
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration("default", 2000).copyOnRead(false).copyOnWrite(false).eternal(false).transactionalMode("OFF").persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE).synchronousWrites(false)).overflowToOffHeap(false);
        if (!Iterables.isEmpty(configuration.getPeers()) && port != null) {
            Object hostProperty;
            String host = configuration.getHost();
            if (StringUtils.isNotBlank((String)host)) {
                System.setProperty("java.rmi.server.hostname", host);
                hostProperty = "hostName=" + host + ",";
            } else {
                hostProperty = "";
            }
            defaultCacheConfiguration.cacheEventListenerFactory(EhcacheClientImpl.setFactoryConfigValues(new CacheConfiguration.CacheEventListenerFactoryConfiguration(), RMICacheReplicatorFactory.class, "replicateAsynchronously=true,replicatePuts=false,replicatePutsViaCopyreplicateUpdates=false,replicateUpdatesViaCopy=false,replicateRemovals=true,asynchronousReplicationIntervalMillis=100,asynchronousReplicationMaximumBatchSize=32"));
            config.cacheManagerPeerListenerFactory(EhcacheClientImpl.createFactoryConfig(RMICacheManagerPeerListenerFactory.class, (String)hostProperty + "port=" + port));
            config.cacheManagerPeerProviderFactory(EhcacheClientImpl.createFactoryConfig(RMICacheManagerPeerProviderFactory.class, "peerDiscovery=manual"));
        }
        config.defaultCache(defaultCacheConfiguration);
        return config;
    }

    @Nonnull
    private static FactoryConfiguration<FactoryConfiguration<?>> createFactoryConfig(@Nonnull Class<?> factory, @Nonnull String properties) {
        return EhcacheClientImpl.setFactoryConfigValues(new FactoryConfiguration(), factory, properties);
    }

    private static <T extends FactoryConfiguration<?>> T setFactoryConfigValues(@Nonnull T result, @Nonnull Class<?> factory, @Nonnull String properties) {
        result.setClass(factory.getCanonicalName());
        result.setProperties(properties);
        return result;
    }

    @Override
    public <T> T get(EhCacheName cacheName, String key) throws ClassCastException {
        Element element = this.getCache(cacheName).get((Serializable)((Object)key));
        return EhcacheClientImpl.elementToValue(element);
    }

    @CheckForNull
    private static <T> T elementToValue(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        Object cast = element.getObjectValue();
        return (T)cast;
    }

    @Nonnull
    private Ehcache createCache(@Nonnull EhCacheName cacheName) {
        String name = cacheName.getCacheName();
        this._cacheManager.addCacheIfAbsent(name);
        Ehcache newCache = this._cacheManager.getEhcache(name);
        newCache.getCacheConfiguration().maxEntriesLocalHeap(cacheName.getMaxElements()).timeToLiveSeconds(cacheName.getTimeToLiveSeconds());
        return newCache;
    }

    @Override
    public <T> Map<String, T> getBulk(EhCacheName cacheName, Collection<String> keys) throws ClassCastException {
        Map result = this.getCache(cacheName).getAll(keys);
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : result.entrySet()) {
            T value = EhcacheClientImpl.elementToValue((Element)entry.getValue());
            if (value == null) continue;
            String key = (String)entry.getKey();
            resultBuilder.put((Object)key, value);
        }
        return resultBuilder.build();
    }

    private Ehcache getCache(EhCacheName cacheName) {
        Ehcache cache = (Ehcache)this._caches.get((Object)cacheName);
        if (cache == null) {
            throw new IllegalStateException("You propably forget to register the cache " + cacheName.getCacheName() + " of type " + cacheName.getClass() + " in your EhcacheClientConfiguration?");
        }
        return cache;
    }

    @Override
    public Future<Boolean> add(EhCacheName cacheName, String key, Object o) {
        this.getCache(cacheName).put(new Element((Object)key, o));
        return TrueFuture.INSTANCE;
    }

    @Override
    public Future<Boolean> delete(EhCacheName cacheName, String key) {
        this.getCache(cacheName).remove((Serializable)((Object)key));
        return TrueFuture.INSTANCE;
    }

    @Override
    public Future<Boolean> deleteKeys(EhCacheName cacheName, Iterable<String> keys) {
        this.getCache(cacheName).removeAll((Collection)ImmutableSet.copyOf(keys));
        return TrueFuture.INSTANCE;
    }

    @Override
    public Future<Boolean> flush() {
        this._cacheManager.clearAll();
        return TrueFuture.INSTANCE;
    }

    public void destroy() {
        LOG.info("shutting down EhcacheClientImpl");
        if (INSTANCE_COUNT.decrementAndGet() <= 0) {
            this._cacheManager.shutdown();
        }
    }

    @Override
    public void deleteAll(EhCacheName cacheName) {
        this.getCache(cacheName).removeAll();
    }
}

