/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.cache;

import com.freiheit.toro.cache.CacheName;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public final class CacheKey {
    public static final Function<CacheKey, String> TO_KEY_STRING = new Function<CacheKey, String>(){

        public String apply(CacheKey input) {
            return input != null ? input.getKey() : null;
        }
    };
    private final CacheName _name;
    private final String _key;

    public CacheKey(@Nonnull CacheName name, @Nonnull String key) {
        this._name = name;
        this._key = key;
    }

    public CacheKey(@Nonnull CacheName name, Object ... objects) {
        this(name, Joiner.on((char)',').join(objects));
    }

    public CacheKey(@Nonnull CacheName name, @Nonnull Number number) {
        this(name, number.toString());
    }

    @Nonnull
    public CacheName getCacheName() {
        return this._name;
    }

    @Nonnull
    public String getKey() {
        return this._key;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._name, this._key});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof CacheKey && Objects.equal((Object)this._name, (Object)((CacheKey)obj)._name) && Objects.equal((Object)this._key, (Object)((CacheKey)obj)._key);
    }

    public String toString() {
        return this._name.getCacheName() + "#" + this._key;
    }
}

