/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.shared.model.settings;

import com.freiheit.toro.account.shared.model.settings.BirthdayVisibility;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Birthday
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer _day;
    private Integer _month;
    private Integer _year;

    @Deprecated
    public Birthday() {
    }

    private Birthday(@Nonnull Date date, @Nonnull BirthdayVisibility birthdayVisibility) {
        this._day = birthdayVisibility.isDayVisible() ? Integer.valueOf(date.getDate()) : null;
        this._month = birthdayVisibility.isDayVisible() ? Integer.valueOf(date.getMonth()) : null;
        this._year = birthdayVisibility.isYearVisible() ? Integer.valueOf(date.getYear()) : null;
    }

    @CheckForNull
    public static Birthday create(@Nullable Date date, @Nullable BirthdayVisibility birthdayVisibility) {
        return date != null && birthdayVisibility != null && birthdayVisibility != BirthdayVisibility.NONE ? new Birthday(date, birthdayVisibility) : null;
    }

    @Nonnull
    public String format(DateFormatter formatter) {
        if (this._year != null) {
            if (this._day != null && this._month != null) {
                Date date = new Date(this._year, this._month, this._day);
                return formatter.formatDate(date);
            }
            return String.valueOf(this._year + 1900);
        }
        if (this._day != null && this._month != null) {
            Date date = new Date(new Date().getYear(), this._month, this._day);
            return formatter.formatDateNoYear(date);
        }
        return "";
    }

    @CheckForNull
    public Integer getDay() {
        return this._day;
    }

    @CheckForNull
    public Integer getMonth() {
        if (this._month == null) {
            return null;
        }
        return this._month + 1;
    }

    @CheckForNull
    public Integer getYear() {
        if (this._year == null) {
            return null;
        }
        return this._year + 1900;
    }

    public String toString() {
        return MoreObjects.toStringHelper(Birthday.class).add("year-1900", (Object)this._year).add("month-1", (Object)this._month).add("day", (Object)this._day).toString();
    }

    public static int getMaximumAllowedYear() {
        return new Date().getYear() + 1901;
    }

    public static interface BirthdayFormatter {
        @Nonnull
        public String getDateFormat(Date var1);

        @Nonnull
        public String getDateFormatNoYear(Date var1);
    }
}

