/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.business.impl;

import com.freiheit.toro.account.business.VerificationCodeService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.secret.business.HMacSecretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.util.server.Base64Util;
import de.justsoftware.onx.util.server.HMacUtil;
import de.justsoftware.toolbox.clock.Clock;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VerificationCodeServiceImpl
implements VerificationCodeService {
    protected static final int LOGIN_CODE_LIFETIME_IN_MINUTES = 60;
    private static final int USER_ACTIVATION_CODE_LENGTH = 38;
    private static final int TRANSPORT_LOGIN_CODE_LENGTH = 48;
    private final Clock _clock;
    private final SecretService _secretService;

    @Autowired
    public VerificationCodeServiceImpl(@Nonnull Clock clock, @Nonnull SecretService secretService) {
        this._clock = clock;
        this._secretService = secretService;
    }

    @Override
    public String generateUserActivationCodeForId(PersonId userId) {
        HMacSecretKey secret = (HMacSecretKey)this._secretService.getSecretKey(SecretKeyName.USER_ACTIVATION_SECRET);
        byte[] toHash = ByteBuffer.allocate(8).putLong(userId.getId()).array();
        return Base64Util.encode(HMacUtil.appendHMac(toHash, secret));
    }

    @Override
    public PersonId verifyUserActivationCode(String activationCode) {
        if (activationCode.length() != 38) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(Base64Util.decode(activationCode));
        PersonId id = new PersonId(buffer.getLong());
        String expectedCode = this.generateUserActivationCodeForId(id);
        if (expectedCode.equalsIgnoreCase(activationCode.trim())) {
            return id;
        }
        return null;
    }

    private String generateLoginCodeForId(PersonId personId, DateTime time) {
        HMacSecretKey secret = (HMacSecretKey)this._secretService.getSecretKey(SecretKeyName.TRANSPORT_LOGIN_SECRET);
        byte[] toHash = ByteBuffer.allocate(16).putLong(personId.getId()).putLong(time.getMillis()).array();
        return Base64Util.encode(HMacUtil.appendHMac(toHash, secret));
    }

    @Override
    public String generateTemporaryLoginCodeForId(PersonId personId) {
        return this.generateLoginCodeForId(personId, this._clock.now());
    }

    @Override
    public PersonId verifyTemporaryLoginCode(String loginCode) {
        if (loginCode.length() != 48) {
            return null;
        }
        ByteBuffer codeBuffer = ByteBuffer.wrap(Base64Util.decode(loginCode));
        PersonId id = new PersonId(codeBuffer.getLong());
        DateTime timestamp = new DateTime(codeBuffer.getLong());
        DateTime lastValidTimeStamp = timestamp.plusMinutes(60);
        if (this._clock.now().isAfter((ReadableInstant)lastValidTimeStamp)) {
            return null;
        }
        String expectedCode = this.generateLoginCodeForId(id, timestamp);
        if (!expectedCode.equalsIgnoreCase(loginCode.trim())) {
            return null;
        }
        return id;
    }
}

