/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container.editor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SGridLayout;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SPanel;
import org.wings.STextField;
import org.wings.border.SBorder;
import org.wings.border.SLineBorder;

public class MapEditor
extends SPanel {
    private static final long serialVersionUID = 1L;
    private final STextField _keyTextField = new STextField();
    private final SButton _addButton = new SButton("add"){
        private static final long serialVersionUID = 1L;
        {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = MapEditor.this._keyTextField.getText();
                    if (!MapEditor.this._textFields.containsKey(key)) {
                        MapEditor.this._textFields.put(key, MapEditor.this.createNewTextField(""));
                        MapEditor.this._keyTextField.setText("");
                        MapEditor.this.update();
                    }
                }
            });
        }
    };
    private final Map<String, STextField> _textFields = Maps.newHashMap();
    private String _removeButtonText;
    private Color _textFieldColor;

    public MapEditor(Map<String, String> existing) {
        super((SLayoutManager)new SGridLayout(3));
        for (Map.Entry<String, String> entry : existing.entrySet()) {
            this._textFields.put(entry.getKey(), this.createNewTextField(entry.getValue()));
        }
        this.update();
    }

    private STextField createNewTextField(String key) {
        STextField result = new STextField(key);
        this.applyTextFieldAttributes(result);
        return result;
    }

    private void applyTextFieldAttributes(STextField textField) {
        SLineBorder border = this._textFieldColor != null ? new SLineBorder(this._textFieldColor, 2) : null;
        textField.setBorder((SBorder)border);
    }

    public ImmutableMap<String, String> getValue() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, STextField> entry : this._textFields.entrySet()) {
            result.put((Object)entry.getKey(), (Object)entry.getValue().getText());
        }
        return result.build();
    }

    private void update() {
        this.removeAll();
        for (Map.Entry<String, STextField> entry : this._textFields.entrySet()) {
            final String key = entry.getKey();
            this.add((SComponent)new SLabel(key));
            this.add((SComponent)entry.getValue());
            this.add((SComponent)new SButton(this._removeButtonText){
                private static final long serialVersionUID = 1L;
                {
                    super(arg0);
                    this.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MapEditor.this._textFields.remove(key);
                            MapEditor.this.update();
                        }
                    });
                }
            });
        }
        this.add((SComponent)this._keyTextField);
        this.add((SComponent)this._addButton);
    }

    public void setTextFieldColor(Color color) {
        this._textFieldColor = color;
        for (STextField textField : this._textFields.values()) {
            this.applyTextFieldAttributes(textField);
        }
    }

    public void setKeyTextFieldColor(Color color) {
        this._keyTextField.setBorder((SBorder)new SLineBorder(color, 2));
    }

    public void setKeyTextFieldSize(int size) {
        this._keyTextField.setColumns(size);
    }

    public void setAddButtonText(String s) {
        this._addButton.setText(s);
    }

    public void setRemoveButtonText(String s) {
        this._removeButtonText = s;
        this.update();
    }
}

