/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container.editor;

import com.freiheit.superoperty.container.CollectionConverter;
import com.freiheit.superoperty.editor.UIEditorFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.wings.SButton;
import org.wings.SComponent;
import org.wings.SGridLayout;
import org.wings.SLabel;
import org.wings.SLayoutManager;
import org.wings.SPanel;
import org.wings.STabbedPane;
import org.wings.STextArea;

public class CollectionEditor
implements UIEditorFactory {
    protected SComponent _myEditorUI;
    protected String _userHint;
    protected CollectionConverter _myConverter;

    public CollectionEditor(String userHint, CollectionConverter myConverter) {
        this._userHint = userHint;
        this._myConverter = myConverter;
    }

    public SComponent createEditComponent(String value) {
        return new CollectionEditorUI(this._myConverter, value);
    }

    public String extractEditedValue(SComponent comp) {
        CollectionEditorUI collectionEditorUI = (CollectionEditorUI)comp;
        return collectionEditorUI.getStringRepresentation();
    }

    public String getUserHint() {
        return this._userHint;
    }

    protected class CollectionEditorUI
    extends STabbedPane {
        private static final long serialVersionUID = -4401500756619708140L;
        CollectionConverter _converter;
        final SPanel _textviewPanel = new SPanel((SLayoutManager)new SGridLayout(1));
        final STextArea _valueTextArea = new STextArea(20, 35);
        final SPanel _listViewPanel = new SPanel((SLayoutManager)new SGridLayout(1));
        final SPanel _listPanel = new SPanel((SLayoutManager)new SGridLayout(1));
        final ElementItem _addTextField = new ElementItem("", "add", "New value:");
        private int _selectedIndexBeforeDisabled = -1;

        public CollectionEditorUI(CollectionConverter converter, String value) {
            this._converter = converter;
            this.setLayout((SLayoutManager)new SGridLayout(1));
            this.addChangeListener(new ChangeListener(){
                private Integer _lastSelectedIndex = null;

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (this._lastSelectedIndex != null && CollectionEditorUI.this.getSelectedIndex() != this._lastSelectedIndex.intValue()) {
                        if (CollectionEditorUI.this.getSelectedIndex() == 0) {
                            CollectionEditorUI.this.updateFromString(CollectionEditorUI.this._valueTextArea.getText());
                        } else {
                            CollectionEditorUI.this.updateFromString(CollectionEditorUI.this.getValueStringFromList());
                        }
                    }
                    this._lastSelectedIndex = CollectionEditorUI.this.getSelectedIndex();
                }
            });
            this.updateFromString(value);
            this._addTextField.addActionListiner(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object values = CollectionEditorUI.this.getStringRepresentation();
                    values = values == null || ((String)values).trim().length() == 0 ? CollectionEditorUI.this._addTextField.getValue() : (String)values + CollectionEditor.this._myConverter.getSeperator() + CollectionEditorUI.this._addTextField.getValue();
                    CollectionEditorUI.this._addTextField.setValue("");
                    CollectionEditorUI.this.updateFromString((String)values);
                }
            });
            this._listViewPanel.add((SComponent)this._listPanel);
            this._listViewPanel.add((SComponent)this._addTextField);
            this.add((SComponent)this._listViewPanel, "Listen-Ansischt");
            this._textviewPanel.add((SComponent)this._valueTextArea);
            this.add((SComponent)this._textviewPanel, "Text-Ansischt");
        }

        public void setEnabled(boolean enabled) {
            if (!enabled) {
                this._selectedIndexBeforeDisabled = this.getSelectedIndex();
                this.setSelectedIndex(1);
            } else if (this._selectedIndexBeforeDisabled >= 0) {
                this.setSelectedIndex(this._selectedIndexBeforeDisabled);
            }
            this._valueTextArea.setEnabled(enabled);
            super.setEnabled(enabled);
        }

        private void updateFromArray(String[] array) {
            this._listPanel.removeAll();
            for (int i = 0; i < array.length; ++i) {
                ElementItem element = new ElementItem(array[i], "remove", String.valueOf(i) + ": ");
                element.addActionListiner(new RemoveActionListener(this._listPanel, (SComponent)element));
                this._listPanel.add((SComponent)element);
            }
            this._valueTextArea.setText(this.getValueStringFromList());
        }

        private void updateFromString(String stringRepresentation) {
            this.updateFromArray(this._converter.convertToCollection(stringRepresentation).toArray(new String[0]));
        }

        public String getValueStringFromList() {
            StringBuilder result = new StringBuilder();
            String seperator = "";
            for (SComponent component : this._listPanel.getComponents()) {
                if (!(component instanceof ElementItem)) continue;
                ElementItem tArea = (ElementItem)component;
                result.append(seperator).append(tArea.getValue());
                seperator = CollectionEditor.this._myConverter.getSeperator();
            }
            return result.toString();
        }

        public String getStringRepresentation() {
            if (this.getSelectedIndex() == 0) {
                return this.getValueStringFromList();
            }
            return this._valueTextArea.getText();
        }

        private class RemoveActionListener
        implements ActionListener {
            private final SPanel _parent;
            private final SComponent _element;

            public RemoveActionListener(SPanel parent, SComponent element) {
                this._parent = parent;
                this._element = element;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this._parent.remove(this._element);
                CollectionEditorUI.this.updateFromString(CollectionEditorUI.this.getValueStringFromList());
            }
        }

        private class ElementItem
        extends SPanel {
            private static final long serialVersionUID = -7296010642425081243L;
            private final SLabel _title = new SLabel();
            private final STextArea _value = new STextArea();
            private final SButton _button = new SButton();

            public ElementItem(String value, String buttonText, String title) {
                this.setLayout((SLayoutManager)new SGridLayout(3));
                this._value.setColumns(35);
                this._value.setRows(1);
                this._value.setText(value);
                this._button.setText(buttonText);
                this._title.setText(title);
                this._title.setHorizontalAlignment(50);
                this.add((SComponent)this._title);
                this.add((SComponent)this._value);
                this.add((SComponent)this._button);
            }

            public String getValue() {
                return this._value.getText();
            }

            public void setValue(String value) {
                this._value.setText(value);
            }

            public void addActionListiner(ActionListener listner) {
                this._button.addActionListener(listner);
            }
        }
    }
}

