/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.superoperty.container;

import com.freiheit.superoperty.PropertyStringConverter;
import com.freiheit.superoperty.container.editor.MenuLinksUIEditorFactory;
import com.freiheit.superoperty.editor.UIEditorFactory;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.menu.server.model.AllEntitiesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.CustomMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MyContentsMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.MySubscribedPagesMenuLinkDefinition;
import de.justsoftware.onx.menu.server.model.StaticMenuLinkDefinition;
import de.justsoftware.onx.menu.shared.model.ExpandStatus;
import de.justsoftware.onx.menu.shared.model.MenuLinkLevel;
import de.justsoftware.onx.menu.shared.model.StaticMenuLink;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenulinksConverter
implements PropertyStringConverter {
    private static final ImmutableSet<String> DEFAULT_ROLES = ImmutableSet.of();
    private static final Logger LOG = LoggerFactory.getLogger(MenulinksConverter.class);
    private static final String LEVEL = "level";
    private static final String ROLES = "roles";
    private static final String EXPAND_STATUS = "expand_status";
    private static final String ICON = "icon";
    private static final String URL = "url";
    private static final String TYPE = "type";
    private static final String CUSTOM = "custom";
    private static final String MY_CONTENTS = "my_contents";
    private static final String MY_SUBSCRIBED_PAGES = "my_subscribed_pages";
    private static final String STATIC = "static";
    private static final String TRANSLATION = "translation";
    private static final String VALUE = "value";
    private static final boolean HAS_LEVELS = true;
    private static final String ALL_ENTITIES = "all_entities";
    private static final String ENTITY_TYPE = "entity_type";
    private static final Function<String, MenuLinkDefinition> OLD_FORMAT_PARSE = input -> {
        StaticMenuLink staticMenuLink;
        String trimmed = StringUtils.trimToEmpty((String)input);
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.startsWith("ENTITY_")) {
            return new MyContentsMenuLinkDefinition(new MenuLinkLevel(0, ExpandStatus.DEFAULT), DEFAULT_ROLES, EntityType.valueOf(trimmed.substring("ENTITY_".length())));
        }
        try {
            staticMenuLink = StaticMenuLink.valueOf(trimmed);
        }
        catch (RuntimeException e) {
            LOG.error("invalid format skipping " + input, (Throwable)e);
            return null;
        }
        return new StaticMenuLinkDefinition(new MenuLinkLevel(0, ExpandStatus.DEFAULT), DEFAULT_ROLES, staticMenuLink).accept(new MenuLinkDefinition.StaticDefaultVisitor<MenuLinkDefinition>(){

            @Override
            public MenuLinkDefinition visitCustomLink(CustomMenuLinkDefinition c) {
                return c;
            }

            @Override
            public MenuLinkDefinition visitMyContentsLink(MyContentsMenuLinkDefinition m) {
                return m;
            }

            @Override
            public MenuLinkDefinition visitAllEntitiesLink(AllEntitiesMenuLinkDefinition allEntitiesLink) {
                return allEntitiesLink;
            }

            @Override
            public MenuLinkDefinition visitMySubscribedPagesLink(MySubscribedPagesMenuLinkDefinition link) {
                return link;
            }

            @Override
            protected MenuLinkDefinition visitStatic(StaticMenuLinkDefinition s) {
                return s;
            }
        });
    };

    @Nonnull
    private static Optional<JSONObject> staticMenuLinkDefinitionToJSON(@Nonnull StaticMenuLinkDefinition definition) {
        try {
            JSONObject result = MenulinksConverter.createJsonObject(STATIC, definition);
            result.put(VALUE, (Object)definition.getStaticMenuLink().name());
            return Optional.of(result);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<JSONObject> mySubscribedPagesLinkDefinitionToJSON(@Nonnull MySubscribedPagesMenuLinkDefinition definition) {
        try {
            JSONObject result = MenulinksConverter.createJsonObject(MY_SUBSCRIBED_PAGES, definition);
            result.put(ICON, (Object)definition.getIcon());
            result.put(ENTITY_TYPE, (Object)definition.getRootEntityType().name());
            return Optional.of(result);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<JSONObject> myContentLinkDefinitionToJSON(@Nonnull MyContentsMenuLinkDefinition definition) {
        try {
            JSONObject result = MenulinksConverter.createJsonObject(MY_CONTENTS, definition);
            result.put(ENTITY_TYPE, (Object)definition.getEntityType().name());
            return Optional.of(result);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<JSONObject> allEntitiesMenuLinkDefinitionToJSON(AllEntitiesMenuLinkDefinition definition) {
        try {
            JSONObject result = MenulinksConverter.createJsonObject(ALL_ENTITIES, definition);
            result.put(ENTITY_TYPE, (Object)definition.getEntityType().name());
            return Optional.of(result);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<JSONObject> customLinkDefinitionToJSON(@Nonnull CustomMenuLinkDefinition definition) {
        try {
            JSONObject result = MenulinksConverter.createJsonObject(CUSTOM, definition);
            result.put(URL, (Object)definition.getUrl());
            result.put(ICON, (Object)definition.getIcon());
            JSONObject translations = new JSONObject();
            for (Map.Entry translation : definition.getTranslations().entrySet()) {
                translations.put((String)translation.getKey(), translation.getValue());
            }
            result.put(TRANSLATION, (Object)translations);
            return Optional.of(result);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    @Nonnull
    protected static JSONObject createJsonObject(@Nullable String type, @Nonnull MenuLinkDefinition menulink) throws JSONException {
        MenuLinkLevel linkLevel = menulink.getLinkLevel();
        JSONObject result = new JSONObject();
        result.put(TYPE, (Object)type);
        result.put(ROLES, (Object)new JSONArray(menulink.getRoles()));
        if (linkLevel != null) {
            result.put(LEVEL, linkLevel.getLevel());
            result.put(EXPAND_STATUS, (Object)linkLevel.getExpandStatus());
        }
        return result;
    }

    public String checkValid(String stringRepresentation) {
        return stringRepresentation;
    }

    public String convertFromObject(Object obj) {
        ImmutableList list = (ImmutableList)obj;
        return MenulinksConverter.convertFromObject((Collection<? extends MenuLinkDefinition>)list);
    }

    @Nonnull
    public String convertFromObjects(@Nonnull Collection<? extends MenuLinkDefinition> list) {
        return MenulinksConverter.convertFromObject(list);
    }

    @Nonnull
    public static String convertFromObject(@Nonnull Collection<? extends MenuLinkDefinition> list) {
        Collection jsonObjects = list.stream().map(MenuLinkToJson.INSTANCE).filter(Objects::nonNull).collect(Collectors.toList());
        JSONArray result = new JSONArray(jsonObjects);
        return result.toString();
    }

    public ImmutableList<MenuLinkDefinition> convertToObject(String s) {
        if (s.startsWith("[")) {
            try {
                JSONArray jsonResult = new JSONArray(s);
                ImmutableList.Builder result = ImmutableList.builder();
                for (int i = 0; i < jsonResult.length(); ++i) {
                    JSONObject j = null;
                    try {
                        j = jsonResult.getJSONObject(i);
                        MenuLinkLevel linkLevel = j.has(LEVEL) ? new MenuLinkLevel(j.getInt(LEVEL), this.extractExpandStatus(j)) : null;
                        String type = j.getString(TYPE);
                        if (type.equalsIgnoreCase(CUSTOM)) {
                            result.add((Object)new CustomMenuLinkDefinition(linkLevel, this.extractRoles(j), IconType.valueOf((String)j.getString(ICON)), j.getString(URL), MenulinksConverter.extractTranslations(j.getJSONObject(TRANSLATION))));
                            continue;
                        }
                        if (type.equalsIgnoreCase(MY_CONTENTS)) {
                            result.add((Object)new MyContentsMenuLinkDefinition(linkLevel, this.extractRoles(j), EntityType.valueOf(j.getString(ENTITY_TYPE))));
                            continue;
                        }
                        if (type.equalsIgnoreCase(ALL_ENTITIES)) {
                            result.add((Object)new AllEntitiesMenuLinkDefinition(linkLevel, this.extractRoles(j), EntityType.valueOf(j.getString(ENTITY_TYPE))));
                            continue;
                        }
                        if (type.equalsIgnoreCase(MY_SUBSCRIBED_PAGES)) {
                            result.add((Object)new MySubscribedPagesMenuLinkDefinition(linkLevel, this.extractRoles(j), IconType.valueOf((String)j.getString(ICON)), EntityType.valueOf(j.getString(ENTITY_TYPE))));
                            continue;
                        }
                        if (!type.equalsIgnoreCase(STATIC)) continue;
                        result.add((Object)new StaticMenuLinkDefinition(linkLevel, this.extractRoles(j), StaticMenuLink.valueOf(j.getString(VALUE))));
                        continue;
                    }
                    catch (RuntimeException e) {
                        LOG.error("invalid format skipping " + j, (Throwable)e);
                    }
                }
                return result.build();
            }
            catch (JSONException e) {
                LOG.error("invalid format, returning empty " + s, (Throwable)e);
                return ImmutableList.of();
            }
        }
        return (ImmutableList)Stream.of(s.split(",")).map(OLD_FORMAT_PARSE).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private ExpandStatus extractExpandStatus(JSONObject j) throws JSONException {
        if (!j.has(EXPAND_STATUS)) {
            return ExpandStatus.DEFAULT;
        }
        return ExpandStatus.valueOf(j.getString(EXPAND_STATUS));
    }

    private ImmutableSet<String> extractRoles(JSONObject j) throws JSONException {
        if (!j.has(ROLES)) {
            return ImmutableSet.of();
        }
        JSONArray jsonArray = j.getJSONArray(ROLES);
        if (jsonArray == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (int i = 0; i < jsonArray.length(); ++i) {
            result.add((Object)jsonArray.getString(i));
        }
        return result.build();
    }

    private static ImmutableMap<String, String> extractTranslations(JSONObject json) {
        Object[] names = JSONObject.getNames((JSONObject)json);
        if (names == null) {
            return ImmutableMap.of();
        }
        Map result = Maps.asMap((Set)ImmutableSet.copyOf((Object[])names), input -> {
            try {
                return json.getString(input);
            }
            catch (JSONException e) {
                return null;
            }
        });
        return ImmutableMap.copyOf((Map)result);
    }

    public UIEditorFactory getEditorFactory() {
        return new MenuLinksUIEditorFactory(this, true);
    }

    public void setConfiguration(String arg0) {
    }

    static class MenuLinkToJson
    extends MenuLinkDefinition.StaticDefaultVisitor<Optional<JSONObject>>
    implements Function<MenuLinkDefinition, JSONObject> {
        public static final MenuLinkToJson INSTANCE = new MenuLinkToJson();

        MenuLinkToJson() {
        }

        @Override
        public JSONObject apply(MenuLinkDefinition input) {
            return input != null ? (JSONObject)input.accept(this).orElse(null) : null;
        }

        @Override
        public Optional<JSONObject> visitCustomLink(CustomMenuLinkDefinition customMenuLinkDefinition) {
            return MenulinksConverter.customLinkDefinitionToJSON(customMenuLinkDefinition);
        }

        @Override
        public Optional<JSONObject> visitMyContentsLink(MyContentsMenuLinkDefinition myContentsLinkDefinition) {
            return MenulinksConverter.myContentLinkDefinitionToJSON(myContentsLinkDefinition);
        }

        @Override
        public Optional<JSONObject> visitAllEntitiesLink(AllEntitiesMenuLinkDefinition allEntitiesLink) {
            return MenulinksConverter.allEntitiesMenuLinkDefinitionToJSON(allEntitiesLink);
        }

        @Override
        public Optional<JSONObject> visitMySubscribedPagesLink(MySubscribedPagesMenuLinkDefinition link) {
            return MenulinksConverter.mySubscribedPagesLinkDefinitionToJSON(link);
        }

        @Override
        protected Optional<JSONObject> visitStatic(StaticMenuLinkDefinition s) {
            return MenulinksConverter.staticMenuLinkDefinitionToJSON(s);
        }
    }
}

