/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.util.sql;

import de.justsoftware.util.sql.AbstractShadowTableSqlGenerator;
import de.justsoftware.util.sql.OracleShadowTableSqlGenerator;
import de.justsoftware.util.sql.PostgresShadowTableSqlGenerator;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;

@ParametersAreNonnullByDefault
public class ShadowTableSqlGeneratorApp {
    private static final String POSTGRESQL_OPT = "postgresql";
    private static final String ORACLE_OPT = "oracle";

    public static void main(String[] args) {
        Parameters params = ShadowTableSqlGeneratorApp.readParameters(args);
        PrintStream out = null;
        try {
            AbstractShadowTableSqlGenerator gen;
            out = new PrintStream((OutputStream)new FileOutputStream(params._fileName, false), true, "UTF-8");
            AbstractShadowTableSqlGenerator abstractShadowTableSqlGenerator = gen = params._dbtype.equals(POSTGRESQL_OPT) ? new PostgresShadowTableSqlGenerator(params._dbUrl, params._dbUser, params._dbPwd) : new OracleShadowTableSqlGenerator(params._dbUrl, params._dbUser, params._dbPwd);
            if (params._tableName != null) {
                gen.generateScriptForTable(params._tableName, out);
            } else {
                gen.generateScriptForAllTables(out);
            }
            out.flush();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            try {
                throw new ShadowTableSqlGeneratorAppException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    @Nonnull
    private static Parameters readParameters(String[] args) {
        ShadowTableSqlGeneratorApp.checkArgumentLength(args);
        Parameters params = new Parameters();
        int i = 0;
        while (i < args.length) {
            String currentArg;
            if ((currentArg = args[i++]).equals("-dbtype")) {
                params._dbtype = args[i++].toLowerCase(AbstractShadowTableSqlGenerator.LOCALE);
                continue;
            }
            if (currentArg.equals("-dburl")) {
                params._dbUrl = args[i++];
                continue;
            }
            if (currentArg.equals("-dbuser")) {
                params._dbUser = args[i++];
                continue;
            }
            if (currentArg.equals("-dbpwd")) {
                params._dbPwd = args[i++];
                continue;
            }
            if (currentArg.equals("-table")) {
                params._tableName = args[i++].toUpperCase(AbstractShadowTableSqlGenerator.LOCALE);
                continue;
            }
            if (currentArg.equals("-filename")) {
                params._fileName = args[i++];
                continue;
            }
            throw new IllegalArgumentException("unknown parameter " + currentArg);
        }
        ShadowTableSqlGeneratorApp.checkArguments(params);
        return params;
    }

    private static void checkArgumentLength(String[] args) {
        if (args.length % 2 == 1) {
            ShadowTableSqlGeneratorApp.printUsage();
        }
    }

    private static void checkArguments(Parameters params) {
        if (!POSTGRESQL_OPT.equals(params._dbtype) && !ORACLE_OPT.equals(params._dbtype)) {
            ShadowTableSqlGeneratorApp.printUsage();
        }
        if (params._fileName == null || params._dbUser == null || params._dbPwd == null || params._dbUrl == null) {
            ShadowTableSqlGeneratorApp.printUsage();
        }
    }

    private static void printUsage() {
        throw new IllegalArgumentException("required parameters:   -dbtype <postgresql|oracle>\n  -dburl <url>\n  -dbuser <username>\n  -dbpwd <password>\n  -filename <filename>\noptional parameters:\n  -table <tablename>\n");
    }

    @ParametersAreNonnullByDefault
    private static class ShadowTableSqlGeneratorAppException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ShadowTableSqlGeneratorAppException(Throwable t) {
            super(t);
        }
    }

    private static class Parameters {
        String _dbtype = "postgresql";
        String _dbUrl = "jdbc:postgresql://localhost/toro_test";
        String _dbUser = "toro";
        String _dbPwd = "toro";
        String _tableName = null;
        String _fileName = null;

        private Parameters() {
        }
    }
}

