/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.util.sql;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.util.sql.AbstractShadowTableSqlGenerator;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oracle.jdbc.driver.OracleDriver;

@ParametersAreNonnullByDefault
public class OracleShadowTableSqlGenerator
extends AbstractShadowTableSqlGenerator {
    private static final String SELECT_ALL_TABLES = "select table_name from user_tables order by 1";
    private static final String DESCRIBE_TABLE = "select column_name, data_type, char_length, data_precision, data_scale from user_tab_columns where table_name = ? order by column_id";
    private static final String DESCRIBE_PRIMARY_KEY = "select cols.column_name from user_constraints cons join user_cons_columns cols on cons.constraint_name = cols.constraint_name where cons.table_name = ? and cons.constraint_type = 'P' order by cols.position";
    private final String _jdbcUrl;
    private final String _dbUser;
    private final String _dbPwd;

    public OracleShadowTableSqlGenerator(String jdbcUrl, String dbUser, String dbPwd) {
        this._jdbcUrl = jdbcUrl;
        this._dbUser = dbUser;
        this._dbPwd = dbPwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iterable<String> iterTables(Connection conn) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(SELECT_ALL_TABLES);
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            arrayList = tables;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }

    @Override
    protected Class<? extends Driver> getJdbcDriver() {
        return OracleDriver.class;
    }

    @Override
    protected String getJdbcUrl() {
        return this._jdbcUrl;
    }

    @Override
    protected String getUser() {
        return this._dbUser;
    }

    @Override
    protected String getPassword() {
        return this._dbPwd;
    }

    @Override
    protected String getDeleteActionIdType() {
        return "number(19, 0) NOT NULL";
    }

    @Override
    protected String normalizeTableName(String tableName) {
        return tableName.toUpperCase(LOCALE);
    }

    @Nonnull
    private String normalizeTypeName(String dataType) {
        return dataType.toLowerCase(LOCALE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AbstractShadowTableSqlGenerator.Column> describeTable(String tableName, Connection conn) throws SQLException {
        ArrayList<AbstractShadowTableSqlGenerator.Column> arrayList;
        ArrayList<AbstractShadowTableSqlGenerator.Column> columns = new ArrayList<AbstractShadowTableSqlGenerator.Column>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(DESCRIBE_TABLE);
            stmt.setString(1, tableName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                String dataType = rs.getString(2);
                BigDecimal charLength = (BigDecimal)rs.getObject(3);
                BigDecimal dataPrecision = (BigDecimal)rs.getObject(4);
                BigDecimal dataScale = (BigDecimal)rs.getObject(5);
                columns.add(new AbstractShadowTableSqlGenerator.Column(columnName, this.createDatatypeString(dataType, charLength, dataPrecision, dataScale)));
            }
            if (columns.isEmpty()) {
                throw new IllegalStateException("No columns found for table " + tableName);
            }
            arrayList = columns;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }

    @Nonnull
    private String createDatatypeString(String dataType, @Nullable BigDecimal charLength, @Nullable BigDecimal dataPrecision, @Nullable BigDecimal dataScale) {
        if (ImmutableSet.of((Object)"CHAR", (Object)"VARCHAR2", (Object)"NVARCHAR2").contains((Object)dataType)) {
            return this.normalizeTypeName(dataType) + "(" + charLength.toString() + " char)";
        }
        if (ImmutableSet.of((Object)"CLOB", (Object)"NCLOB", (Object)"BLOB", (Object)"DATE", (Object)"RAW").contains((Object)dataType)) {
            return this.normalizeTypeName(dataType);
        }
        if (dataType.equals("FLOAT")) {
            return "float(" + dataPrecision.toString() + ")";
        }
        if (dataType.equals("NUMBER")) {
            if (dataPrecision == null) {
                return dataScale != null ? "number(*, " + dataScale.toString() + ")" : "number";
            }
            return "number(" + dataPrecision.toString() + (String)(dataScale != null ? ", " + dataScale.toString() : "") + ")";
        }
        if (dataType.startsWith("TIMESTAMP")) {
            return this.normalizeTypeName(dataType);
        }
        throw new IllegalStateException("Unexpected data type " + dataType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> describePrimaryKey(String tableName, Connection conn) throws SQLException {
        ArrayList<String> arrayList;
        ArrayList<String> primaryKeys = new ArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(DESCRIBE_PRIMARY_KEY);
            stmt.setString(1, tableName);
            rs = stmt.executeQuery();
            while (rs.next()) {
                primaryKeys.add(rs.getString(1));
            }
            arrayList = primaryKeys;
        }
        catch (Throwable throwable) {
            this.close(rs, stmt);
            throw throwable;
        }
        this.close(rs, stmt);
        return arrayList;
    }
}

