BEGIN;

CREATE TABLE conversation_change (
    id bigint NOT NULL PRIMARY KEY,
    conversation_id bigint NOT NULL,
    participant_id bigint NOT NULL,
    change_type varchar(255) NOT NULL,
    create_date timestamp NOT NULL DEFAULT now(),
    CONSTRAINT conversation_change_participant_id_fk FOREIGN KEY (participant_id) REFERENCES person (id) ON DELETE CASCADE,
    CONSTRAINT conversation_change_uq UNIQUE (conversation_id, participant_id, change_type)
);

CREATE SEQUENCE conversation_change_seq
    START WITH 1
    INCREMENT BY 1;

CREATE INDEX conversation_change_create_date_idx ON conversation_change (create_date);
CREATE INDEX conversation_change_participant_id_create_date_idx ON conversation_change (participant_id, create_date);

COMMIT;
