BEGIN;

CREATE SEQUENCE conversation_search_queue_seq;

CREATE TABLE conversation_search_queue (
    id BIGINT NOT NULL,
    item_id BIGINT NOT NULL,
    item_type VARCHAR(32) NOT NULL,
    conversation_index_type VARCHAR(32) NOT NULL,
    created_at TIMESTAMP NOT NULL DEFAULT clock_timestamp(),
    modified_at TIMESTAMP NOT NULL DEFAULT clock_timestamp(),
    in_progress character(1) NOT NULL DEFAULT 'f',
    lock_id BIGINT,
    CONSTRAINT conversation_search_queue_pk PRIMARY KEY (id)
);

CREATE INDEX conversation_search_queue_item_progress_create_date_idx ON conversation_search_queue (item_id, item_type, in_progress, created_at ASC);
CREATE INDEX conversation_search_queue_id_lock_progress_idx ON conversation_search_queue (id, lock_id, in_progress);
CREATE INDEX conversation_search_queue_modify_date_idx ON conversation_search_queue (modified_at);
CREATE INDEX conversation_search_queue_creation_date_idx ON conversation_search_queue (created_at ASC);
CREATE INDEX conversation_search_queue_progress_modify_date_idx ON conversation_search_queue (in_progress, modified_at);

COMMIT;
