-- refs JUST-12075
BEGIN;

-- updates wrong entity_version_components due to configuration bugs of the "old freigabe" --
UPDATE entity_version_components SET multi_wiki_version_id = fixed_components.multi_wiki_version_id
FROM (
SELECT ev.id AS entity_version_id, mwv.id AS multi_wiki_version_id
    FROM multi_wiki_version mwv
    INNER JOIN multi_wiki mw ON mw.id=mwv.wiki_id
    INNER JOIN entity_version ev ON mw.entity_id=ev.entity_id
    LEFT JOIN entity_version_components evc ON evc.multi_wiki_version_id=mwv.id
    WHERE evc.entity_version_id IS NULL
    AND mwv.id in (SELECT MAX(mwv.id)
        FROM multi_wiki_version mwv
        INNER JOIN multi_wiki mw ON mw.id=mwv.wiki_id
        GROUP BY mw.entity_id)
    AND ev.id in (SELECT MAX(ev2.id)
        FROM entity_version ev2 WHERE ev2.entity_id=mw.entity_id
        GROUP BY ev2.entity_id)
    ) AS fixed_components
WHERE entity_version_components.entity_version_id=fixed_components.entity_version_id;


COMMIT;