BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00004, '8.0', '00004_#patch_create_table_notification', 'FEATURE', '#9779 - Basis für Notifications schaffen', now());

CREATE SEQUENCE notification_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;

CREATE TABLE notification (
    id bigint NOT NULL,
    notification_type varchar(255) NOT NULL,
    state varchar(255) NOT NULL,
    originator_id bigint NOT NULL,
    receiver_id bigint NOT NULL,
    entity_id bigint,
    subject_id bigint,
    create_date timestamp without time zone DEFAULT now() NOT NULL,
    modify_date timestamp without time zone DEFAULT now(),

    CONSTRAINT noti_pk PRIMARY KEY (id),
    CONSTRAINT noti_org_fk FOREIGN KEY (originator_id) REFERENCES person(id),
    CONSTRAINT noti_rec_fk FOREIGN KEY (receiver_id) REFERENCES person(id)
);

CREATE INDEX idx_notification_key ON notification (receiver_id, state);

COMMIT;
