BEGIN;

INSERT INTO version (id, release, name, type, description, "date")
VALUES (00004, '7.8', '00004_#patch_move_comment_from_attachment_to_workstream', 'FEATURE', '#8385 Workstream: Kommentare zu Anhängen nicht mehr mit Microblog-Beitrag synchronisieren', now());


CREATE TABLE tmp_move_comment(
    comment_id BIGINT, 
    new_parent_item_id BIGINT
);

INSERT INTO tmp_move_comment(comment_id, new_parent_item_id)
SELECT c.id as comment_id, a.entry_id as new_parent_id
FROM 
  mdl_album_image AS i, 
  workstream_attachment AS a,
  mdl_comment AS c
WHERE i.id = a.item_id AND a.item_type = 'ALBUM_IMAGE'
AND i.id = c.parent_item_id AND c.parent_item_type = 'ALBUM_IMAGE';

INSERT INTO tmp_move_comment(comment_id, new_parent_item_id)
SELECT c.id as comment_id, a.entry_id as new_parent_id
FROM 
  mdl_album_image AS i, 
  workstream_attachment AS a,
  mdl_comment AS c
WHERE i.id = a.item_id AND a.item_type = 'DOCUMENT'
AND i.id = c.parent_item_id AND c.parent_item_type = 'DOCUMENT';

INSERT INTO tmp_move_comment(comment_id, new_parent_item_id)
SELECT c.id as comment_id, a.entry_id as new_parent_id
FROM 
  mdl_album_image AS i, 
  workstream_attachment AS a,
  mdl_comment AS c
WHERE i.id = a.item_id AND a.item_type = 'VIDEOLINK'
AND i.id = c.parent_item_id AND c.parent_item_type = 'VIDEOLINK';

UPDATE mdl_comment AS c
SET parent_item_type = 'WORKSTREAM_MESSAGE',
    parent_item_id = (
        SELECT new_parent_item_id
        FROM tmp_move_comment AS t
        WHERE t.comment_id = c.id)
WHERE c.id IN (SELECT comment_id FROM tmp_move_comment);

DROP TABLE tmp_move_comment;

COMMIT;
