BEGIN;

INSERT INTO version (
  id, "release", name, "type", description, "date"
) VALUES (
  01312, '6.13', '1312_6.13-unify-schema-names.sql', 'FEATURE', 'fixes #4369 Bennenung von Tabellen, Spalten, Indize, Primary Keys und Foreign Keys vereinheitlichen', now()
);

-- drop views that might break
DROP VIEW IF EXISTS solr_contact_data_view;
DROP VIEW IF EXISTS solr_entity_view;
DROP VIEW IF EXISTS solr_newsblog_view;
DROP VIEW IF EXISTS solr_person_view;

-- drop unused tables
DROP TABLE IF EXISTS politview CASCADE;
DROP TABLE IF EXISTS religview CASCADE;

-- rename tables
-- ALTER TABLE PGR_TABLE_NAME RENAME TO ORA_TABLE_NAME;

ALTER TABLE appointments RENAME TO appointment;
ALTER TABLE appointment_widget_configurations RENAME TO appointment_widget_cfg;

ALTER TABLE cities RENAME TO city;

ALTER TABLE default_albums RENAME TO default_album;

ALTER TABLE document_files RENAME TO document_file;
ALTER TABLE document_versions RENAME TO document_version;

ALTER TABLE dynamic_person_attributes RENAME TO dynamic_person_attribute;

ALTER TABLE email_notification_settings RENAME TO email_notification_setting;
ALTER TABLE email_users RENAME TO email_user;

ALTER TABLE entity_linked_entity_type_privacy RENAME TO entity_to_entity_type_privacy;

ALTER TABLE entity_navigation_links RENAME TO entity_nav_link;
ALTER TABLE entity_navigation_sublinks RENAME TO entity_nav_sublink;

ALTER TABLE entity_options RENAME TO entity_option;

ALTER TABLE file_types RENAME TO file_type;

ALTER TABLE "group" RENAME TO group_table;

ALTER TABLE ignorelist RENAME TO ignore_list;

ALTER TABLE industries RENAME TO industry;

ALTER TABLE kadgets RENAME TO kadget;

ALTER TABLE "like" RENAME TO like_table;

ALTER TABLE map_document_files_appointments RENAME TO map_document_file_appointment;
ALTER TABLE map_document_files_groups RENAME TO map_document_file_group;
ALTER TABLE map_document_files_networks RENAME TO map_document_file_network;
ALTER TABLE map_document_files_wiki_groups RENAME TO map_document_file_wiki_group;

ALTER TABLE map_kadgets_networks RENAME TO map_kadget_network;

ALTER TABLE map_person_relationshiptype RENAME TO map_person_relationship_type;

ALTER TABLE mdl_comments RENAME TO mdl_comment;

ALTER TABLE mdl_documents RENAME TO mdl_document;
ALTER TABLE mdl_document_versions RENAME TO mdl_document_version;

ALTER TABLE mdl_videolink RENAME TO mdl_video_link;

ALTER TABLE message_recipients RENAME TO message_recipient;

ALTER TABLE network_designs RENAME TO network_design;

ALTER TABLE network_links RENAME TO network_link;

ALTER TABLE network_navigation_links RENAME TO network_nav_link;

ALTER TABLE network_widget_configurations RENAME TO network_widget_cfg;

ALTER TABLE newsblog RENAME TO news_blog;

ALTER TABLE occupations RENAME TO occupation;

ALTER TABLE person_roles RENAME TO person_role;

ALTER TABLE person_to_roles RENAME TO person_to_role;

ALTER TABLE profile_visibility_for_roles RENAME TO profile_visibility_for_role;

ALTER TABLE random_entity_member_roles_component_config RENAME TO random_member_component_cfg;

ALTER TABLE relationshipstatus RENAME TO relationship_status;
ALTER TABLE relationshiptype RENAME TO relationship_type;

ALTER TABLE schooltype RENAME TO school_type;

ALTER TABLE start_page_profiles RENAME TO start_page_profile;

ALTER TABLE survey_predefined_multiple_choice_answer RENAME TO survey_predefined_answer;

ALTER TABLE universitytype RENAME TO university_type;

ALTER TABLE user_settings RENAME TO user_setting;

ALTER TABLE videolink RENAME TO video_link;
ALTER TABLE videolink_comment RENAME TO video_link_comment;

ALTER TABLE wiki_group_widget_configurations RENAME TO wiki_group_widget_cfg;

ALTER TABLE workstream_attachments RENAME TO workstream_attachment;
ALTER TABLE workstream_entries RENAME TO workstream_entry;
ALTER TABLE workstream_entry_attributes RENAME TO workstream_entry_attribute;

-- rename columns
-- ALTER TABLE ORA_TABLE_NAME RENAME COLUMN PGR_COLUMN_NAME TO ORA_COLUMN_NAME;

ALTER TABLE album RENAME COLUMN createdate TO create_date;

ALTER TABLE appointment RENAME COLUMN appointment_id TO id;

ALTER TABLE email_notification_setting RENAME COLUMN subscribe_root_items_activated TO subscribe_root_items;
ALTER TABLE email_notification_setting RENAME COLUMN subscribe_other_items_activated TO subscribe_other_items;

ALTER TABLE email_user RENAME COLUMN userid TO user_id;

ALTER TABLE employment RENAME COLUMN startat TO start_at;
ALTER TABLE employment RENAME COLUMN endat TO end_at;
ALTER TABLE employment RENAME COLUMN is_current TO current;

ALTER TABLE entity RENAME COLUMN is_subdomain_deactivated TO subdomain_deactivated;

ALTER TABLE entity_contact_data RENAME COLUMN notresolvable TO not_resolvable;

ALTER TABLE entity_design RENAME COLUMN navigation_background_color TO nav_bg_color;
ALTER TABLE entity_design RENAME COLUMN navigation_quicklink_color TO nav_quicklink_color;
ALTER TABLE entity_design RENAME COLUMN header_background_color TO header_bg_color;
ALTER TABLE entity_design RENAME COLUMN heading_box_background_color TO heading_box_bg_color;
ALTER TABLE entity_design RENAME COLUMN subheading_box_background_color TO subheading_box_bg_color;
ALTER TABLE entity_design RENAME COLUMN inner_background_color TO inner_bg_color;
ALTER TABLE entity_design RENAME COLUMN outer_background_color TO outer_bg_color;
ALTER TABLE entity_design RENAME COLUMN button_background_color TO button_bg_color;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_background_color TO horizontal_nav_bg_color;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_link_color TO horizontal_nav_link_color;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation TO horizontal_nav;
ALTER TABLE entity_design RENAME COLUMN background_horizontal_repeat TO bg_horizontal_repeat;
ALTER TABLE entity_design RENAME COLUMN background_vertical_repeat TO bg_vertical_repeat;
ALTER TABLE entity_design RENAME COLUMN background_image TO bg_image;
ALTER TABLE entity_design RENAME COLUMN background_scroll_fix TO bg_scroll_fix;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_selected_link TO horizontal_nav_selected_link;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_selected_background TO horizontal_nav_selected_bg;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_sub_line TO horizontal_nav_sub_line;
ALTER TABLE entity_design RENAME COLUMN horizontal_navigation_selected_image TO horizontal_nav_selected_image;

ALTER TABLE facebook_user RENAME COLUMN facebook_user_id TO id;

ALTER TABLE forum RENAME COLUMN affilation TO affiliation;

ALTER TABLE forum_topic RENAME COLUMN topic_id TO id;

ALTER TABLE group_table RENAME COLUMN group_id TO id;

ALTER TABLE image_comment RENAME COLUMN createdate TO create_date;

ALTER TABLE kadget RENAME COLUMN is_published TO published;
ALTER TABLE kadget RENAME COLUMN is_external TO external;

ALTER TABLE mdl_album RENAME COLUMN is_module TO module;

ALTER TABLE message RENAME COLUMN message_id TO id;

ALTER TABLE network RENAME COLUMN is_additional_url_deactivated TO additional_url_deactivated;
ALTER TABLE network RENAME COLUMN horizontal_navigation TO horizontal_nav;
ALTER TABLE network RENAME COLUMN navigation_separator TO nav_separator;

ALTER TABLE network_design RENAME COLUMN navigation_background_color TO nav_bg_color;
ALTER TABLE network_design RENAME COLUMN navigation_quicklink_color TO nav_quicklink_color;
ALTER TABLE network_design RENAME COLUMN navigation_separator_background_color TO nav_separator_bg_color;
ALTER TABLE network_design RENAME COLUMN navigation_separator_text_color TO nav_separator_text_color;
ALTER TABLE network_design RENAME COLUMN header_background_color TO header_bg_color;
ALTER TABLE network_design RENAME COLUMN heading_box_background_color TO heading_box_bg_color;
ALTER TABLE network_design RENAME COLUMN heading_box_text_color TO heading_box_txt_color;
ALTER TABLE network_design RENAME COLUMN subheading_box_background_color TO subheading_box_bg_color;
ALTER TABLE network_design RENAME COLUMN inner_background_color TO inner_bg_color;
ALTER TABLE network_design RENAME COLUMN outer_background_color TO outer_bg_color;
ALTER TABLE network_design RENAME COLUMN button_background_color TO button_bg_color;
ALTER TABLE network_design RENAME COLUMN horizontal_navigation_background_color TO horizontal_nav_bg_color;
ALTER TABLE network_design RENAME COLUMN horizontal_navigation_link_color TO horizontal_nav_link_color;

ALTER TABLE network_widget_cfg RENAME COLUMN is_member_images_visible TO member_images_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_feed_visible TO feed_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_news_visible TO news_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_events_visible TO events_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_member_videolinks_visible TO member_videolinks_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_forum_visible TO forum_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_wall_visible TO wall_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_members_visible TO members_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_groups_visible TO groups_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_images_visible TO images_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_videolinks_visible TO videolinks_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_details_visible TO details_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_news_member_writable TO news_member_writable;
ALTER TABLE network_widget_cfg RENAME COLUMN is_events_member_writable TO events_member_writable;
ALTER TABLE network_widget_cfg RENAME COLUMN is_images_member_writable TO images_member_writable;
ALTER TABLE network_widget_cfg RENAME COLUMN is_videolinks_member_writable TO videolinks_member_writable;
ALTER TABLE network_widget_cfg RENAME COLUMN is_kadgets_visible TO kadgets_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_network_links_visible TO network_links_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_documents_visible TO documents_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_documents_member_writable TO documents_member_writable;
ALTER TABLE network_widget_cfg RENAME COLUMN is_wikis_visible TO wikis_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_wiki_tag_cloud_visible TO wiki_tag_cloud_visible;
ALTER TABLE network_widget_cfg RENAME COLUMN is_google_map_visible TO google_map_visible;

ALTER TABLE person RENAME COLUMN person_id TO id;
ALTER TABLE person RENAME COLUMN profile_visibility_for_roles_restricted TO visible_for_restricted;

ALTER TABLE relationship_status RENAME COLUMN relationshipstatus_id TO id;
ALTER TABLE relationship_status RENAME COLUMN relationshipstatus_name TO name;

ALTER TABLE relationship_type RENAME COLUMN relationshiptype_id TO id;
ALTER TABLE relationship_type RENAME COLUMN relationshiptype_name TO name;

ALTER TABLE rights RENAME COLUMN is_admin TO admin;
ALTER TABLE rights RENAME COLUMN is_translator TO translator;

ALTER TABLE school_type RENAME COLUMN schooltype_id TO id;
ALTER TABLE school_type RENAME COLUMN schooltype_name TO name;

ALTER TABLE survey_participant_answer RENAME COLUMN survey_predefined_multiple_choice_answer_id TO survey_predefined_answer_id;

ALTER TABLE survey_question RENAME COLUMN is_freetext_answer TO freetext_answer;

ALTER TABLE university_type RENAME COLUMN universitytype_id TO id;
ALTER TABLE university_type RENAME COLUMN universitytype_name TO name;

ALTER TABLE video_link_comment RENAME COLUMN createtime TO create_date;

ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_member_images_visible TO member_images_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_members_visible TO members_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_forum_visible TO forum_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_wall_visible TO wall_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_documents_visible TO documents_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_privacy_visible TO privacy_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_wikis_visible TO wikis_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_groups_visible TO groups_visible;
ALTER TABLE wiki_group_widget_cfg RENAME COLUMN is_admin_list_visible TO admin_list_visible;

ALTER TABLE zodiac RENAME COLUMN zodiac_id TO id;
ALTER TABLE zodiac RENAME COLUMN zodiac_name TO name;

-- drop existing constraints and create new ones


-- replace boolean true by 't' and false by 'f'

ALTER TABLE appointment ALTER COLUMN participant_limited DROP DEFAULT;
ALTER TABLE appointment ALTER COLUMN participant_limited TYPE character(1) USING (CASE WHEN participant_limited is null THEN null ELSE CASE WHEN participant_limited THEN 't' ELSE 'f' END END);
ALTER TABLE appointment ALTER COLUMN participant_limited SET DEFAULT (null);

ALTER TABLE appointment_widget_cfg ALTER COLUMN list_participant_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_participant_visible TYPE character(1) USING (CASE WHEN list_participant_visible is null THEN null ELSE CASE WHEN list_participant_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_participant_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN list_wait_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_wait_visible TYPE character(1) USING (CASE WHEN list_wait_visible is null THEN null ELSE CASE WHEN list_wait_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_wait_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN list_undecided_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_undecided_visible TYPE character(1) USING (CASE WHEN list_undecided_visible is null THEN null ELSE CASE WHEN list_undecided_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_undecided_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN list_rejected_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_rejected_visible TYPE character(1) USING (CASE WHEN list_rejected_visible is null THEN null ELSE CASE WHEN list_rejected_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN list_rejected_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN news_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN news_visible TYPE character(1) USING (CASE WHEN news_visible is null THEN null ELSE CASE WHEN news_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN news_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN documents_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN documents_visible TYPE character(1) USING (CASE WHEN documents_visible is null THEN null ELSE CASE WHEN documents_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN documents_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN album_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN album_visible TYPE character(1) USING (CASE WHEN album_visible is null THEN null ELSE CASE WHEN album_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN album_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN video_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN video_visible TYPE character(1) USING (CASE WHEN video_visible is null THEN null ELSE CASE WHEN video_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN video_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN forum_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN forum_visible TYPE character(1) USING (CASE WHEN forum_visible is null THEN null ELSE CASE WHEN forum_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN forum_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN wall_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN wall_visible TYPE character(1) USING (CASE WHEN wall_visible is null THEN null ELSE CASE WHEN wall_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN wall_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN admin_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN admin_visible TYPE character(1) USING (CASE WHEN admin_visible is null THEN null ELSE CASE WHEN admin_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN admin_visible SET DEFAULT ('t');

ALTER TABLE appointment_widget_cfg ALTER COLUMN privacy_visible DROP DEFAULT;
ALTER TABLE appointment_widget_cfg ALTER COLUMN privacy_visible TYPE character(1) USING (CASE WHEN privacy_visible is null THEN null ELSE CASE WHEN privacy_visible THEN 't' ELSE 'f' END END);
ALTER TABLE appointment_widget_cfg ALTER COLUMN privacy_visible SET DEFAULT ('t');

ALTER TABLE contact_data_basic ALTER COLUMN zipcode_successive DROP DEFAULT;
ALTER TABLE contact_data_basic ALTER COLUMN zipcode_successive TYPE character(1) USING (CASE WHEN zipcode_successive is null THEN null ELSE CASE WHEN zipcode_successive THEN 't' ELSE 'f' END END);
ALTER TABLE contact_data_basic ALTER COLUMN zipcode_successive SET DEFAULT ('f');

ALTER TABLE email_notification_setting ALTER COLUMN subscribe_root_items DROP DEFAULT;
ALTER TABLE email_notification_setting ALTER COLUMN subscribe_root_items TYPE character(1) USING (CASE WHEN subscribe_root_items is null THEN null ELSE CASE WHEN subscribe_root_items THEN 't' ELSE 'f' END END);
ALTER TABLE email_notification_setting ALTER COLUMN subscribe_root_items SET DEFAULT ('t');

ALTER TABLE email_notification_setting ALTER COLUMN subscribe_other_items DROP DEFAULT;
ALTER TABLE email_notification_setting ALTER COLUMN subscribe_other_items TYPE character(1) USING (CASE WHEN subscribe_other_items is null THEN null ELSE CASE WHEN subscribe_other_items THEN 't' ELSE 'f' END END);
ALTER TABLE email_notification_setting ALTER COLUMN subscribe_other_items SET DEFAULT ('t');

ALTER TABLE email_notification_setting ALTER COLUMN notifications_enabled DROP DEFAULT;
ALTER TABLE email_notification_setting ALTER COLUMN notifications_enabled TYPE character(1) USING (CASE WHEN notifications_enabled is null THEN null ELSE CASE WHEN notifications_enabled THEN 't' ELSE 'f' END END);
ALTER TABLE email_notification_setting ALTER COLUMN notifications_enabled SET DEFAULT ('t');

ALTER TABLE employment ALTER COLUMN current DROP DEFAULT;
ALTER TABLE employment ALTER COLUMN current TYPE character(1) USING (CASE WHEN current is null THEN null ELSE CASE WHEN current THEN 't' ELSE 'f' END END);
ALTER TABLE employment ALTER COLUMN current SET DEFAULT (null);

ALTER TABLE entity ALTER COLUMN participant_limited DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN participant_limited TYPE character(1) USING (CASE WHEN participant_limited is null THEN null ELSE CASE WHEN participant_limited THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN participant_limited SET DEFAULT ('f');

ALTER TABLE entity ALTER COLUMN subdomain_deactivated DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN subdomain_deactivated TYPE character(1) USING (CASE WHEN subdomain_deactivated is null THEN null ELSE CASE WHEN subdomain_deactivated THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN subdomain_deactivated SET DEFAULT ('f');

ALTER TABLE entity ALTER COLUMN widgets_show_sub_entities DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN widgets_show_sub_entities TYPE character(1) USING (CASE WHEN widgets_show_sub_entities is null THEN null ELSE CASE WHEN widgets_show_sub_entities THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN widgets_show_sub_entities SET DEFAULT ('t');

ALTER TABLE entity ALTER COLUMN aggregate_workstream DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN aggregate_workstream TYPE character(1) USING (CASE WHEN aggregate_workstream is null THEN null ELSE CASE WHEN aggregate_workstream THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN aggregate_workstream SET DEFAULT ('t');

ALTER TABLE entity ALTER COLUMN public_visible DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN public_visible TYPE character(1) USING (CASE WHEN public_visible is null THEN null ELSE CASE WHEN public_visible THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN public_visible SET DEFAULT ('t');

ALTER TABLE entity ALTER COLUMN stream_workstream_to_parents DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN stream_workstream_to_parents TYPE character(1) USING (CASE WHEN stream_workstream_to_parents is null THEN null ELSE CASE WHEN stream_workstream_to_parents THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN stream_workstream_to_parents SET DEFAULT ('t');

ALTER TABLE entity ALTER COLUMN use_parent_admin_as_coadmin DROP DEFAULT;
ALTER TABLE entity ALTER COLUMN use_parent_admin_as_coadmin TYPE character(1) USING (CASE WHEN use_parent_admin_as_coadmin is null THEN null ELSE CASE WHEN use_parent_admin_as_coadmin THEN 't' ELSE 'f' END END);
ALTER TABLE entity ALTER COLUMN use_parent_admin_as_coadmin SET DEFAULT ('f');

ALTER TABLE entity_component ALTER COLUMN visible DROP DEFAULT;
ALTER TABLE entity_component ALTER COLUMN visible TYPE character(1) USING (CASE WHEN visible is null THEN null ELSE CASE WHEN visible THEN 't' ELSE 'f' END END);
ALTER TABLE entity_component ALTER COLUMN visible SET DEFAULT ('t');

ALTER TABLE entity_component ALTER COLUMN open DROP DEFAULT;
ALTER TABLE entity_component ALTER COLUMN open TYPE character(1) USING (CASE WHEN open is null THEN null ELSE CASE WHEN open THEN 't' ELSE 'f' END END);
ALTER TABLE entity_component ALTER COLUMN open SET DEFAULT ('t');

ALTER TABLE entity_contact_data ALTER COLUMN not_resolvable DROP DEFAULT;
ALTER TABLE entity_contact_data ALTER COLUMN not_resolvable TYPE character(1) USING (CASE WHEN not_resolvable is null THEN null ELSE CASE WHEN not_resolvable THEN 't' ELSE 'f' END END);
ALTER TABLE entity_contact_data ALTER COLUMN not_resolvable SET DEFAULT ('f');

ALTER TABLE entity_design ALTER COLUMN box_top_border DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN box_top_border TYPE character(1) USING (CASE WHEN box_top_border is null THEN null ELSE CASE WHEN box_top_border THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN box_top_border SET DEFAULT (null);

ALTER TABLE entity_design ALTER COLUMN box_bottom_border DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN box_bottom_border TYPE character(1) USING (CASE WHEN box_bottom_border is null THEN null ELSE CASE WHEN box_bottom_border THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN box_bottom_border SET DEFAULT (null);

ALTER TABLE entity_design ALTER COLUMN box_left_border DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN box_left_border TYPE character(1) USING (CASE WHEN box_left_border is null THEN null ELSE CASE WHEN box_left_border THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN box_left_border SET DEFAULT (null);

ALTER TABLE entity_design ALTER COLUMN box_right_border DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN box_right_border TYPE character(1) USING (CASE WHEN box_right_border is null THEN null ELSE CASE WHEN box_right_border THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN box_right_border SET DEFAULT (null);

ALTER TABLE entity_design ALTER COLUMN bg_horizontal_repeat DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN bg_horizontal_repeat TYPE character(1) USING (CASE WHEN bg_horizontal_repeat is null THEN null ELSE CASE WHEN bg_horizontal_repeat THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN bg_horizontal_repeat SET DEFAULT ('f');

ALTER TABLE entity_design ALTER COLUMN bg_vertical_repeat DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN bg_vertical_repeat TYPE character(1) USING (CASE WHEN bg_vertical_repeat is null THEN null ELSE CASE WHEN bg_vertical_repeat THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN bg_vertical_repeat SET DEFAULT ('f');

ALTER TABLE entity_design ALTER COLUMN bg_scroll_fix DROP DEFAULT;
ALTER TABLE entity_design ALTER COLUMN bg_scroll_fix TYPE character(1) USING (CASE WHEN bg_scroll_fix is null THEN null ELSE CASE WHEN bg_scroll_fix THEN 't' ELSE 'f' END END);
ALTER TABLE entity_design ALTER COLUMN bg_scroll_fix SET DEFAULT ('f');

ALTER TABLE group_table ALTER COLUMN closed DROP DEFAULT;
ALTER TABLE group_table ALTER COLUMN closed TYPE character(1) USING (CASE WHEN closed is null THEN null ELSE CASE WHEN closed THEN 't' ELSE 'f' END END);
ALTER TABLE group_table ALTER COLUMN closed SET DEFAULT (null);

ALTER TABLE group_table ALTER COLUMN activated DROP DEFAULT;
ALTER TABLE group_table ALTER COLUMN activated TYPE character(1) USING (CASE WHEN activated is null THEN null ELSE CASE WHEN activated THEN 't' ELSE 'f' END END);
ALTER TABLE group_table ALTER COLUMN activated SET DEFAULT ('t');

ALTER TABLE group_table ALTER COLUMN member_may_post_image DROP DEFAULT;
ALTER TABLE group_table ALTER COLUMN member_may_post_image TYPE character(1) USING (CASE WHEN member_may_post_image is null THEN null ELSE CASE WHEN member_may_post_image THEN 't' ELSE 'f' END END);
ALTER TABLE group_table ALTER COLUMN member_may_post_image SET DEFAULT ('t');

ALTER TABLE group_table ALTER COLUMN member_may_post_video DROP DEFAULT;
ALTER TABLE group_table ALTER COLUMN member_may_post_video TYPE character(1) USING (CASE WHEN member_may_post_video is null THEN null ELSE CASE WHEN member_may_post_video THEN 't' ELSE 'f' END END);
ALTER TABLE group_table ALTER COLUMN member_may_post_video SET DEFAULT ('t');

ALTER TABLE group_table ALTER COLUMN member_may_post_document DROP DEFAULT;
ALTER TABLE group_table ALTER COLUMN member_may_post_document TYPE character(1) USING (CASE WHEN member_may_post_document is null THEN null ELSE CASE WHEN member_may_post_document THEN 't' ELSE 'f' END END);
ALTER TABLE group_table ALTER COLUMN member_may_post_document SET DEFAULT ('t');

ALTER TABLE jabber_synced ALTER COLUMN in_progress DROP DEFAULT;
ALTER TABLE jabber_synced ALTER COLUMN in_progress TYPE character(1) USING (CASE WHEN in_progress is null THEN null ELSE CASE WHEN in_progress THEN 't' ELSE 'f' END END);
ALTER TABLE jabber_synced ALTER COLUMN in_progress SET DEFAULT (null);

ALTER TABLE kadget ALTER COLUMN published DROP DEFAULT;
ALTER TABLE kadget ALTER COLUMN published TYPE character(1) USING (CASE WHEN published is null THEN null ELSE CASE WHEN published THEN 't' ELSE 'f' END END);
ALTER TABLE kadget ALTER COLUMN published SET DEFAULT ('f');

ALTER TABLE kadget ALTER COLUMN external DROP DEFAULT;
ALTER TABLE kadget ALTER COLUMN external TYPE character(1) USING (CASE WHEN external is null THEN null ELSE CASE WHEN external THEN 't' ELSE 'f' END END);
ALTER TABLE kadget ALTER COLUMN external SET DEFAULT ('f');

ALTER TABLE language ALTER COLUMN translated DROP DEFAULT;
ALTER TABLE language ALTER COLUMN translated TYPE character(1) USING (CASE WHEN translated is null THEN null ELSE CASE WHEN translated THEN 't' ELSE 'f' END END);
ALTER TABLE language ALTER COLUMN translated SET DEFAULT ('f');

ALTER TABLE like_queue ALTER COLUMN in_progress DROP DEFAULT;
ALTER TABLE like_queue ALTER COLUMN in_progress TYPE character(1) USING (CASE WHEN in_progress is null THEN null ELSE CASE WHEN in_progress THEN 't' ELSE 'f' END END);
ALTER TABLE like_queue ALTER COLUMN in_progress SET DEFAULT ('f');

ALTER TABLE like_table ALTER COLUMN recent DROP DEFAULT;
ALTER TABLE like_table ALTER COLUMN recent TYPE character(1) USING (CASE WHEN recent is null THEN null ELSE CASE WHEN recent THEN 't' ELSE 'f' END END);
ALTER TABLE like_table ALTER COLUMN recent SET DEFAULT ('f');

ALTER TABLE map_url_network ALTER COLUMN current DROP DEFAULT;
ALTER TABLE map_url_network ALTER COLUMN current TYPE character(1) USING (CASE WHEN current is null THEN null ELSE CASE WHEN current THEN 't' ELSE 'f' END END);
ALTER TABLE map_url_network ALTER COLUMN current SET DEFAULT (null);

ALTER TABLE mdl_album ALTER COLUMN module DROP DEFAULT;
ALTER TABLE mdl_album ALTER COLUMN module TYPE character(1) USING (CASE WHEN module is null THEN null ELSE CASE WHEN module THEN 't' ELSE 'f' END END);
ALTER TABLE mdl_album ALTER COLUMN module SET DEFAULT ('t');

ALTER TABLE mdl_album ALTER COLUMN friends_only DROP DEFAULT;
ALTER TABLE mdl_album ALTER COLUMN friends_only TYPE character(1) USING (CASE WHEN friends_only is null THEN null ELSE CASE WHEN friends_only THEN 't' ELSE 'f' END END);
ALTER TABLE mdl_album ALTER COLUMN friends_only SET DEFAULT ('t');

ALTER TABLE mdl_video_link ALTER COLUMN public DROP DEFAULT;
ALTER TABLE mdl_video_link ALTER COLUMN public TYPE character(1) USING (CASE WHEN public is null THEN null ELSE CASE WHEN public THEN 't' ELSE 'f' END END);
ALTER TABLE mdl_video_link ALTER COLUMN public SET DEFAULT ('t');

ALTER TABLE network ALTER COLUMN closed DROP DEFAULT;
ALTER TABLE network ALTER COLUMN closed TYPE character(1) USING (CASE WHEN closed is null THEN null ELSE CASE WHEN closed THEN 't' ELSE 'f' END END);
ALTER TABLE network ALTER COLUMN closed SET DEFAULT (null);

ALTER TABLE network ALTER COLUMN additional_url_deactivated DROP DEFAULT;
ALTER TABLE network ALTER COLUMN additional_url_deactivated TYPE character(1) USING (CASE WHEN additional_url_deactivated is null THEN null ELSE CASE WHEN additional_url_deactivated THEN 't' ELSE 'f' END END);
ALTER TABLE network ALTER COLUMN additional_url_deactivated SET DEFAULT ('f');

ALTER TABLE network ALTER COLUMN widgets_show_sub_networks DROP DEFAULT;
ALTER TABLE network ALTER COLUMN widgets_show_sub_networks TYPE character(1) USING (CASE WHEN widgets_show_sub_networks is null THEN null ELSE CASE WHEN widgets_show_sub_networks THEN 't' ELSE 'f' END END);
ALTER TABLE network ALTER COLUMN widgets_show_sub_networks SET DEFAULT ('f');

ALTER TABLE network_design ALTER COLUMN box_top_border DROP DEFAULT;
ALTER TABLE network_design ALTER COLUMN box_top_border TYPE character(1) USING (CASE WHEN box_top_border is null THEN null ELSE CASE WHEN box_top_border THEN 't' ELSE 'f' END END);
ALTER TABLE network_design ALTER COLUMN box_top_border SET DEFAULT (null);

ALTER TABLE network_design ALTER COLUMN box_bottom_border DROP DEFAULT;
ALTER TABLE network_design ALTER COLUMN box_bottom_border TYPE character(1) USING (CASE WHEN box_bottom_border is null THEN null ELSE CASE WHEN box_bottom_border THEN 't' ELSE 'f' END END);
ALTER TABLE network_design ALTER COLUMN box_bottom_border SET DEFAULT (null);

ALTER TABLE network_design ALTER COLUMN box_left_border DROP DEFAULT;
ALTER TABLE network_design ALTER COLUMN box_left_border TYPE character(1) USING (CASE WHEN box_left_border is null THEN null ELSE CASE WHEN box_left_border THEN 't' ELSE 'f' END END);
ALTER TABLE network_design ALTER COLUMN box_left_border SET DEFAULT (null);

ALTER TABLE network_design ALTER COLUMN box_right_border DROP DEFAULT;
ALTER TABLE network_design ALTER COLUMN box_right_border TYPE character(1) USING (CASE WHEN box_right_border is null THEN null ELSE CASE WHEN box_right_border THEN 't' ELSE 'f' END END);
ALTER TABLE network_design ALTER COLUMN box_right_border SET DEFAULT (null);

ALTER TABLE network_widget_cfg ALTER COLUMN member_images_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN member_images_visible TYPE character(1) USING (CASE WHEN member_images_visible is null THEN null ELSE CASE WHEN member_images_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN member_images_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN feed_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN feed_visible TYPE character(1) USING (CASE WHEN feed_visible is null THEN null ELSE CASE WHEN feed_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN feed_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN news_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN news_visible TYPE character(1) USING (CASE WHEN news_visible is null THEN null ELSE CASE WHEN news_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN news_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN events_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN events_visible TYPE character(1) USING (CASE WHEN events_visible is null THEN null ELSE CASE WHEN events_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN events_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN member_videolinks_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN member_videolinks_visible TYPE character(1) USING (CASE WHEN member_videolinks_visible is null THEN null ELSE CASE WHEN member_videolinks_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN member_videolinks_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN forum_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN forum_visible TYPE character(1) USING (CASE WHEN forum_visible is null THEN null ELSE CASE WHEN forum_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN forum_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN wall_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN wall_visible TYPE character(1) USING (CASE WHEN wall_visible is null THEN null ELSE CASE WHEN wall_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN wall_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN members_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN members_visible TYPE character(1) USING (CASE WHEN members_visible is null THEN null ELSE CASE WHEN members_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN members_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN groups_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN groups_visible TYPE character(1) USING (CASE WHEN groups_visible is null THEN null ELSE CASE WHEN groups_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN groups_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN images_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN images_visible TYPE character(1) USING (CASE WHEN images_visible is null THEN null ELSE CASE WHEN images_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN images_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_visible TYPE character(1) USING (CASE WHEN videolinks_visible is null THEN null ELSE CASE WHEN videolinks_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN details_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN details_visible TYPE character(1) USING (CASE WHEN details_visible is null THEN null ELSE CASE WHEN details_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN details_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN news_member_writable DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN news_member_writable TYPE character(1) USING (CASE WHEN news_member_writable is null THEN null ELSE CASE WHEN news_member_writable THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN news_member_writable SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN events_member_writable DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN events_member_writable TYPE character(1) USING (CASE WHEN events_member_writable is null THEN null ELSE CASE WHEN events_member_writable THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN events_member_writable SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN images_member_writable DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN images_member_writable TYPE character(1) USING (CASE WHEN images_member_writable is null THEN null ELSE CASE WHEN images_member_writable THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN images_member_writable SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_member_writable DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_member_writable TYPE character(1) USING (CASE WHEN videolinks_member_writable is null THEN null ELSE CASE WHEN videolinks_member_writable THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN videolinks_member_writable SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN kadgets_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN kadgets_visible TYPE character(1) USING (CASE WHEN kadgets_visible is null THEN null ELSE CASE WHEN kadgets_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN kadgets_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN network_links_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN network_links_visible TYPE character(1) USING (CASE WHEN network_links_visible is null THEN null ELSE CASE WHEN network_links_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN network_links_visible SET DEFAULT (null);

ALTER TABLE network_widget_cfg ALTER COLUMN documents_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN documents_visible TYPE character(1) USING (CASE WHEN documents_visible is null THEN null ELSE CASE WHEN documents_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN documents_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN documents_member_writable DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN documents_member_writable TYPE character(1) USING (CASE WHEN documents_member_writable is null THEN null ELSE CASE WHEN documents_member_writable THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN documents_member_writable SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN wikis_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN wikis_visible TYPE character(1) USING (CASE WHEN wikis_visible is null THEN null ELSE CASE WHEN wikis_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN wikis_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN wiki_tag_cloud_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN wiki_tag_cloud_visible TYPE character(1) USING (CASE WHEN wiki_tag_cloud_visible is null THEN null ELSE CASE WHEN wiki_tag_cloud_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN wiki_tag_cloud_visible SET DEFAULT ('t');

ALTER TABLE network_widget_cfg ALTER COLUMN google_map_visible DROP DEFAULT;
ALTER TABLE network_widget_cfg ALTER COLUMN google_map_visible TYPE character(1) USING (CASE WHEN google_map_visible is null THEN null ELSE CASE WHEN google_map_visible THEN 't' ELSE 'f' END END);
ALTER TABLE network_widget_cfg ALTER COLUMN google_map_visible SET DEFAULT ('t');

ALTER TABLE news_blog ALTER COLUMN draft DROP DEFAULT;
ALTER TABLE news_blog ALTER COLUMN draft TYPE character(1) USING (CASE WHEN draft is null THEN null ELSE CASE WHEN draft THEN 't' ELSE 'f' END END);
ALTER TABLE news_blog ALTER COLUMN draft SET DEFAULT ('f');

ALTER TABLE person ALTER COLUMN show_tempstartpage DROP DEFAULT;
ALTER TABLE person ALTER COLUMN show_tempstartpage TYPE character(1) USING (CASE WHEN show_tempstartpage is null THEN null ELSE CASE WHEN show_tempstartpage THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN show_tempstartpage SET DEFAULT ('t');

ALTER TABLE person ALTER COLUMN account_active DROP DEFAULT;
ALTER TABLE person ALTER COLUMN account_active TYPE character(1) USING (CASE WHEN account_active is null THEN null ELSE CASE WHEN account_active THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN account_active SET DEFAULT (null);

ALTER TABLE person ALTER COLUMN terms_accepted DROP DEFAULT;
ALTER TABLE person ALTER COLUMN terms_accepted TYPE character(1) USING (CASE WHEN terms_accepted is null THEN null ELSE CASE WHEN terms_accepted THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN terms_accepted SET DEFAULT (null);

ALTER TABLE person ALTER COLUMN allow_newsletter DROP DEFAULT;
ALTER TABLE person ALTER COLUMN allow_newsletter TYPE character(1) USING (CASE WHEN allow_newsletter is null THEN null ELSE CASE WHEN allow_newsletter THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN allow_newsletter SET DEFAULT ('t');

ALTER TABLE person ALTER COLUMN blocked DROP DEFAULT;
ALTER TABLE person ALTER COLUMN blocked TYPE character(1) USING (CASE WHEN blocked is null THEN null ELSE CASE WHEN blocked THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN blocked SET DEFAULT ('f');

ALTER TABLE person ALTER COLUMN show_actions_in_networks DROP DEFAULT;
ALTER TABLE person ALTER COLUMN show_actions_in_networks TYPE character(1) USING (CASE WHEN show_actions_in_networks is null THEN null ELSE CASE WHEN show_actions_in_networks THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN show_actions_in_networks SET DEFAULT ('t');

ALTER TABLE person ALTER COLUMN pseudonym_enabled DROP DEFAULT;
ALTER TABLE person ALTER COLUMN pseudonym_enabled TYPE character(1) USING (CASE WHEN pseudonym_enabled is null THEN null ELSE CASE WHEN pseudonym_enabled THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN pseudonym_enabled SET DEFAULT (null);

ALTER TABLE person ALTER COLUMN visible_for_restricted DROP DEFAULT;
ALTER TABLE person ALTER COLUMN visible_for_restricted TYPE character(1) USING (CASE WHEN visible_for_restricted is null THEN null ELSE CASE WHEN visible_for_restricted THEN 't' ELSE 'f' END END);
ALTER TABLE person ALTER COLUMN visible_for_restricted SET DEFAULT (null);

ALTER TABLE person_role ALTER COLUMN default_role DROP DEFAULT;
ALTER TABLE person_role ALTER COLUMN default_role TYPE character(1) USING (CASE WHEN default_role is null THEN null ELSE CASE WHEN default_role THEN 't' ELSE 'f' END END);
ALTER TABLE person_role ALTER COLUMN default_role SET DEFAULT ('f');

ALTER TABLE person_role ALTER COLUMN hidden_role DROP DEFAULT;
ALTER TABLE person_role ALTER COLUMN hidden_role TYPE character(1) USING (CASE WHEN hidden_role is null THEN null ELSE CASE WHEN hidden_role THEN 't' ELSE 'f' END END);
ALTER TABLE person_role ALTER COLUMN hidden_role SET DEFAULT ('f');

ALTER TABLE profile_allowed_component ALTER COLUMN may_modify_visibility DROP DEFAULT;
ALTER TABLE profile_allowed_component ALTER COLUMN may_modify_visibility TYPE character(1) USING (CASE WHEN may_modify_visibility is null THEN null ELSE CASE WHEN may_modify_visibility THEN 't' ELSE 'f' END END);
ALTER TABLE profile_allowed_component ALTER COLUMN may_modify_visibility SET DEFAULT (null);

ALTER TABLE rights ALTER COLUMN admin DROP DEFAULT;
ALTER TABLE rights ALTER COLUMN admin TYPE character(1) USING (CASE WHEN admin is null THEN null ELSE CASE WHEN admin THEN 't' ELSE 'f' END END);
ALTER TABLE rights ALTER COLUMN admin SET DEFAULT ('f');

ALTER TABLE rights ALTER COLUMN translator DROP DEFAULT;
ALTER TABLE rights ALTER COLUMN translator TYPE character(1) USING (CASE WHEN translator is null THEN null ELSE CASE WHEN translator THEN 't' ELSE 'f' END END);
ALTER TABLE rights ALTER COLUMN translator SET DEFAULT ('t');

ALTER TABLE start_page_profile ALTER COLUMN activated DROP DEFAULT;
ALTER TABLE start_page_profile ALTER COLUMN activated TYPE character(1) USING (CASE WHEN activated is null THEN null ELSE CASE WHEN activated THEN 't' ELSE 'f' END END);
ALTER TABLE start_page_profile ALTER COLUMN activated SET DEFAULT ('f');

ALTER TABLE start_page_profile ALTER COLUMN deleted DROP DEFAULT;
ALTER TABLE start_page_profile ALTER COLUMN deleted TYPE character(1) USING (CASE WHEN deleted is null THEN null ELSE CASE WHEN deleted THEN 't' ELSE 'f' END END);
ALTER TABLE start_page_profile ALTER COLUMN deleted SET DEFAULT ('f');

ALTER TABLE subscription_notification ALTER COLUMN in_progress DROP DEFAULT;
ALTER TABLE subscription_notification ALTER COLUMN in_progress TYPE character(1) USING (CASE WHEN in_progress is null THEN null ELSE CASE WHEN in_progress THEN 't' ELSE 'f' END END);
ALTER TABLE subscription_notification ALTER COLUMN in_progress SET DEFAULT ('f');

ALTER TABLE survey ALTER COLUMN anonym DROP DEFAULT;
ALTER TABLE survey ALTER COLUMN anonym TYPE character(1) USING (CASE WHEN anonym is null THEN null ELSE CASE WHEN anonym THEN 't' ELSE 'f' END END);
ALTER TABLE survey ALTER COLUMN anonym SET DEFAULT (null);

ALTER TABLE survey ALTER COLUMN participant_may_modify DROP DEFAULT;
ALTER TABLE survey ALTER COLUMN participant_may_modify TYPE character(1) USING (CASE WHEN participant_may_modify is null THEN null ELSE CASE WHEN participant_may_modify THEN 't' ELSE 'f' END END);
ALTER TABLE survey ALTER COLUMN participant_may_modify SET DEFAULT (null);

ALTER TABLE survey ALTER COLUMN auto_delete_answers DROP DEFAULT;
ALTER TABLE survey ALTER COLUMN auto_delete_answers TYPE character(1) USING (CASE WHEN auto_delete_answers is null THEN null ELSE CASE WHEN auto_delete_answers THEN 't' ELSE 'f' END END);
ALTER TABLE survey ALTER COLUMN auto_delete_answers SET DEFAULT (null);

ALTER TABLE survey_question ALTER COLUMN freetext_answer DROP DEFAULT;
ALTER TABLE survey_question ALTER COLUMN freetext_answer TYPE character(1) USING (CASE WHEN freetext_answer is null THEN null ELSE CASE WHEN freetext_answer THEN 't' ELSE 'f' END END);
ALTER TABLE survey_question ALTER COLUMN freetext_answer SET DEFAULT (null);

ALTER TABLE video_link ALTER COLUMN public DROP DEFAULT;
ALTER TABLE video_link ALTER COLUMN public TYPE character(1) USING (CASE WHEN public is null THEN null ELSE CASE WHEN public THEN 't' ELSE 'f' END END);
ALTER TABLE video_link ALTER COLUMN public SET DEFAULT ('f');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN member_images_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN member_images_visible TYPE character(1) USING (CASE WHEN member_images_visible is null THEN null ELSE CASE WHEN member_images_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN member_images_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN members_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN members_visible TYPE character(1) USING (CASE WHEN members_visible is null THEN null ELSE CASE WHEN members_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN members_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN forum_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN forum_visible TYPE character(1) USING (CASE WHEN forum_visible is null THEN null ELSE CASE WHEN forum_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN forum_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wall_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wall_visible TYPE character(1) USING (CASE WHEN wall_visible is null THEN null ELSE CASE WHEN wall_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wall_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN documents_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN documents_visible TYPE character(1) USING (CASE WHEN documents_visible is null THEN null ELSE CASE WHEN documents_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN documents_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN privacy_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN privacy_visible TYPE character(1) USING (CASE WHEN privacy_visible is null THEN null ELSE CASE WHEN privacy_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN privacy_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wikis_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wikis_visible TYPE character(1) USING (CASE WHEN wikis_visible is null THEN null ELSE CASE WHEN wikis_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN wikis_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN groups_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN groups_visible TYPE character(1) USING (CASE WHEN groups_visible is null THEN null ELSE CASE WHEN groups_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN groups_visible SET DEFAULT ('t');

ALTER TABLE wiki_group_widget_cfg ALTER COLUMN admin_list_visible DROP DEFAULT;
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN admin_list_visible TYPE character(1) USING (CASE WHEN admin_list_visible is null THEN null ELSE CASE WHEN admin_list_visible THEN 't' ELSE 'f' END END);
ALTER TABLE wiki_group_widget_cfg ALTER COLUMN admin_list_visible SET DEFAULT ('t');

COMMIT;
