BEGIN;

INSERT INTO version (id, "release", name, "type", description, "date")
VALUES (01308, '6.12', '01308-fix-newsletter-feed-keys', 'BUGFIX', '#4606 wrong keys for newsletter feed entries', now());



CREATE OR REPLACE FUNCTION FIX_KEY (fix_property_name varchar, correct_value varchar) RETURNS VOID AS
$$
BEGIN
    UPDATE base_property SET default_value = correct_value WHERE  property_name = fix_property_name;
END;
$$ LANGUAGE plpgsql;

SELECT FIX_KEY('Newsletter/Entities/templateKey/Group','NEWSLETTER_FEED_GROUPS');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Partnersite','NEWSLETTER_FEED_PARTNERSITES');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Network','NEWSLETTER_FEED_NETWORKS');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Partnersite','NEWSLETTER_FEED_WIKI_PAGES');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Wiki','NEWSLETTER_FEED_WIKI_PAGES');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Appointment','NEWSLETTER_FEED_APPOINTMENTS');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Publication','NEWSLETTER_FEED_PUBLICATIONS');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Topic','NEWSLETTER_FEED_TOPICS');
SELECT FIX_KEY('Newsletter/Entities/templateKey/Article','NEWSLETTER_FEED_ARTICLES');

DROP FUNCTION FIX_KEY (property_name varchar, correct_value varchar);

COMMIT;
